/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.server.web;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.tools.Server;
import org.gridgain.internal.h2.util.StringUtils;

public class DbStarter
implements ServletContextListener {
    private Connection conn;
    private Server server;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Driver.load();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String url = DbStarter.getParameter(servletContext, "db.url", "jdbc:gg-h2:~/test");
            String user = DbStarter.getParameter(servletContext, "db.user", "sa");
            String password = DbStarter.getParameter(servletContext, "db.password", "sa");
            String serverParams = DbStarter.getParameter(servletContext, "db.tcpServer", null);
            if (serverParams != null) {
                String[] params = StringUtils.arraySplit(serverParams, ' ', true);
                this.server = Server.createTcpServer(params);
                this.server.start();
            }
            this.conn = DriverManager.getConnection(url, user, password);
            servletContext.setAttribute("connection", (Object)this.conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getParameter(ServletContext servletContext, String key, String defaultValue) {
        String value = servletContext.getInitParameter(key);
        return value == null ? defaultValue : value;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            Statement stat = this.conn.createStatement();
            stat.execute("SHUTDOWN");
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

