/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.security;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.gridgain.internal.h2.util.Bits;

public class SHA256 {
    private SHA256() {
    }

    public static byte[] getHashWithSalt(byte[] data, byte[] salt) {
        byte[] buff = new byte[data.length + salt.length];
        System.arraycopy(data, 0, buff, 0, data.length);
        System.arraycopy(salt, 0, buff, data.length, salt.length);
        return SHA256.getHash(buff, true);
    }

    public static byte[] getKeyPasswordHash(String userName, char[] password) {
        String user = userName + "@";
        byte[] buff = new byte[2 * (user.length() + password.length)];
        int n = 0;
        int length = user.length();
        for (int i = 0; i < length; ++i) {
            char c = user.charAt(i);
            buff[n++] = (byte)(c >> 8);
            buff[n++] = (byte)c;
        }
        for (char c : password) {
            buff[n++] = (byte)(c >> 8);
            buff[n++] = (byte)c;
        }
        Arrays.fill(password, '\u0000');
        return SHA256.getHash(buff, true);
    }

    public static byte[] getHMAC(byte[] key, byte[] message) {
        return SHA256.initMac(key).doFinal(message);
    }

    private static Mac initMac(byte[] key) {
        if (key.length == 0) {
            key = new byte[1];
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getPBKDF2(byte[] password, byte[] salt, int iterations, int resultLen) {
        byte[] result = new byte[resultLen];
        Mac mac = SHA256.initMac(password);
        int len = 64 + Math.max(32, salt.length + 4);
        byte[] message = new byte[len];
        byte[] macRes = null;
        int k = 1;
        for (int offset = 0; offset < resultLen; offset += 32) {
            for (int i = 0; i < iterations; ++i) {
                if (i == 0) {
                    System.arraycopy(salt, 0, message, 0, salt.length);
                    Bits.writeInt(message, salt.length, k);
                    len = salt.length + 4;
                } else {
                    System.arraycopy(macRes, 0, message, 0, 32);
                    len = 32;
                }
                mac.update(message, 0, len);
                macRes = mac.doFinal();
                for (int j = 0; j < 32 && j + offset < resultLen; ++j) {
                    int n = j + offset;
                    result[n] = (byte)(result[n] ^ macRes[j]);
                }
            }
            ++k;
        }
        Arrays.fill(password, (byte)0);
        return result;
    }

    public static byte[] getHash(byte[] data, boolean nullData) {
        byte[] result;
        try {
            result = MessageDigest.getInstance("SHA-256").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (nullData) {
            Arrays.fill(data, (byte)0);
        }
        return result;
    }
}

