/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.expression.condition.ConditionIn;
import org.gridgain.internal.h2.expression.condition.ConditionInConstantSet;
import org.gridgain.internal.h2.expression.condition.ConditionNot;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class ConditionAndOr
extends Condition {
    public static final int AND = 0;
    public static final int OR = 1;
    private final int andOrType;
    private Expression left;
    private Expression right;

    public ConditionAndOr(int andOrType, Expression left, Expression right) {
        this.andOrType = andOrType;
        this.left = left;
        this.right = right;
        if (left == null || right == null) {
            DbException.throwInternalError(left + " " + right);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote);
        switch (this.andOrType) {
            case 0: {
                builder.append("\n    AND ");
                break;
            }
            case 1: {
                builder.append("\n    OR ");
                break;
            }
            default: {
                throw DbException.throwInternalError("andOrType=" + this.andOrType);
            }
        }
        return this.right.getSQL(builder, alwaysQuote).append(')');
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (this.andOrType == 0) {
            this.left.createIndexConditions(session, filter);
            this.right.createIndexConditions(session, filter);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        Expression r;
        Expression l = this.left.getNotIfPossible(session);
        if (l == null) {
            l = new ConditionNot(this.left);
        }
        if ((r = this.right.getNotIfPossible(session)) == null) {
            r = new ConditionNot(this.right);
        }
        int reversed = this.andOrType == 0 ? 1 : 0;
        return new ConditionAndOr(reversed, l, r);
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        switch (this.andOrType) {
            case 0: {
                if (l != ValueNull.INSTANCE && !l.getBoolean()) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (r != ValueNull.INSTANCE && !r.getBoolean()) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.TRUE;
            }
            case 1: {
                if (l.getBoolean()) {
                    return l;
                }
                Value r = this.right.getValue(session);
                if (r.getBoolean()) {
                    return r;
                }
                if (l == ValueNull.INSTANCE) {
                    return l;
                }
                if (r == ValueNull.INSTANCE) {
                    return r;
                }
                return ValueBoolean.FALSE;
            }
        }
        throw DbException.throwInternalError("type=" + this.andOrType);
    }

    @Override
    public Expression optimize(Session session) {
        Value r;
        Comparison compRight;
        Comparison compLeft;
        Expression added;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        int lc = this.left.getCost();
        int rc = this.right.getCost();
        if (rc < lc) {
            Expression t = this.left;
            this.left = this.right;
            this.right = t;
        }
        if (session.getDatabase().getSettings().optimizeTwoEquals && this.andOrType == 0 && this.left instanceof Comparison && this.right instanceof Comparison && (added = (compLeft = (Comparison)this.left).getAdditional(session, compRight = (Comparison)this.right, true)) != null) {
            added = added.optimize(session);
            return new ConditionAndOr(0, this, added);
        }
        if (this.andOrType == 1 && session.getDatabase().getSettings().optimizeOr) {
            ConditionAndOr condAORight;
            ConditionAndOr condAORLeft;
            Expression reduced;
            Expression added2;
            if (this.left instanceof Comparison && this.right instanceof Comparison) {
                compLeft = (Comparison)this.left;
                compRight = (Comparison)this.right;
                added = compLeft.getAdditional(session, compRight, false);
                if (added != null) {
                    return added.optimize(session);
                }
            } else if (this.left instanceof ConditionIn && this.right instanceof Comparison) {
                added2 = ((ConditionIn)this.left).getAdditional((Comparison)this.right);
                if (added2 != null) {
                    return added2.optimize(session);
                }
            } else if (this.right instanceof ConditionIn && this.left instanceof Comparison) {
                added2 = ((ConditionIn)this.right).getAdditional((Comparison)this.left);
                if (added2 != null) {
                    return added2.optimize(session);
                }
            } else if (this.left instanceof ConditionInConstantSet && this.right instanceof Comparison) {
                added2 = ((ConditionInConstantSet)this.left).getAdditional(session, (Comparison)this.right);
                if (added2 != null) {
                    return added2.optimize(session);
                }
            } else if (this.right instanceof ConditionInConstantSet && this.left instanceof Comparison) {
                added2 = ((ConditionInConstantSet)this.right).getAdditional(session, (Comparison)this.left);
                if (added2 != null) {
                    return added2.optimize(session);
                }
            } else if (this.left instanceof ConditionAndOr && this.right instanceof ConditionAndOr && (reduced = ConditionAndOr.optimizeConditionAndOr(condAORLeft = (ConditionAndOr)this.left, condAORight = (ConditionAndOr)this.right)) != null) {
                return reduced.optimize(session);
            }
        }
        Value l = this.left.isConstant() ? this.left.getValue(session) : null;
        Value value = r = this.right.isConstant() ? this.right.getValue(session) : null;
        if (l == null && r == null) {
            return this;
        }
        if (l != null && r != null) {
            return ValueExpression.get(this.getValue(session));
        }
        switch (this.andOrType) {
            case 0: {
                if (l != null) {
                    if (l != ValueNull.INSTANCE && !l.getBoolean()) {
                        return ValueExpression.get(l);
                    }
                    if (!l.getBoolean()) break;
                    return this.right;
                }
                if (r == null) break;
                if (r != ValueNull.INSTANCE && !r.getBoolean()) {
                    return ValueExpression.get(r);
                }
                if (!r.getBoolean()) break;
                return this.left;
            }
            case 1: {
                if (l != null) {
                    if (l.getBoolean()) {
                        return ValueExpression.get(l);
                    }
                    if (l == ValueNull.INSTANCE) break;
                    return this.right;
                }
                if (r == null) break;
                if (r.getBoolean()) {
                    return ValueExpression.get(r);
                }
                if (r == ValueNull.INSTANCE) break;
                return this.left;
            }
            default: {
                DbException.throwInternalError("type=" + this.andOrType);
            }
        }
        return this;
    }

    @Override
    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (this.andOrType == 0) {
            this.left.addFilterConditions(filter, outerJoin);
            this.right.addFilterConditions(filter, outerJoin);
        } else {
            super.addFilterConditions(filter, outerJoin);
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    private static Expression optimizeConditionAndOr(ConditionAndOr left, ConditionAndOr right) {
        String rightLeftSQL;
        if (left.andOrType != 0 || right.andOrType != 0) {
            return null;
        }
        Expression leftLeft = left.getSubexpression(0);
        Expression leftRight = left.getSubexpression(1);
        Expression rightLeft = right.getSubexpression(0);
        Expression rightRight = right.getSubexpression(1);
        String leftLeftSQL = leftLeft.getSQL(true);
        if (leftLeftSQL.equals(rightLeftSQL = rightLeft.getSQL(true))) {
            ConditionAndOr combinedExpression = new ConditionAndOr(1, leftRight, rightRight);
            return new ConditionAndOr(0, leftLeft, combinedExpression);
        }
        String rightRightSQL = rightRight.getSQL(true);
        if (leftLeftSQL.equals(rightRightSQL)) {
            ConditionAndOr combinedExpression = new ConditionAndOr(1, leftRight, rightLeft);
            return new ConditionAndOr(0, leftLeft, combinedExpression);
        }
        String leftRightSQL = leftRight.getSQL(true);
        if (leftRightSQL.equals(rightLeftSQL)) {
            ConditionAndOr combinedExpression = new ConditionAndOr(1, leftLeft, rightRight);
            return new ConditionAndOr(0, leftRight, combinedExpression);
        }
        if (leftRightSQL.equals(rightRightSQL)) {
            ConditionAndOr combinedExpression = new ConditionAndOr(1, leftLeft, rightLeft);
            return new ConditionAndOr(0, leftRight, combinedExpression);
        }
        return null;
    }
}

