/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueCollectionBase;
import org.gridgain.internal.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private static final Object NULL = new ValueExpression(ValueNull.INSTANCE);
    private static final Object DEFAULT = new ValueExpression(ValueNull.INSTANCE);
    private final Value value;

    private ValueExpression(Value value) {
        this.value = value;
    }

    public static ValueExpression getNull() {
        return (ValueExpression)NULL;
    }

    public static ValueExpression getDefault() {
        return (ValueExpression)DEFAULT;
    }

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        return new ValueExpression(value);
    }

    @Override
    public Value getValue(Session session) {
        return this.value;
    }

    @Override
    public TypeInfo getType() {
        return this.value.getType();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        boolean v;
        if (this.value.getValueType() == 1 && !(v = ((ValueBoolean)this.value).getBoolean())) {
            filter.addIndexCondition(IndexCondition.get(8, null, this));
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isValueSet() {
        return true;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this == DEFAULT) {
            builder.append("DEFAULT");
        } else {
            this.value.getSQL(builder);
        }
        return builder;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        int valueType = this.getType().getValueType();
        if (valueType == 17 || valueType == 39) {
            return ValueExpression.getExpressionColumns(session, (ValueCollectionBase)this.getValue(session));
        }
        return super.getExpressionColumns(session);
    }
}

