/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.constraint;

import java.util.HashSet;
import org.gridgain.internal.h2.constraint.Constraint;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private final boolean primaryKey;

    public ConstraintUnique(Schema schema, int id, String name, Table table, boolean primaryKey) {
        super(schema, id, name, table);
        this.primaryKey = primaryKey;
    }

    @Override
    public Constraint.Type getConstraintType() {
        return this.primaryKey ? Constraint.Type.PRIMARY_KEY : Constraint.Type.UNIQUE;
    }

    @Override
    public String getCreateSQLForCopy(Table forTable, String quotedName) {
        return this.getCreateSQLForCopy(forTable, quotedName, true);
    }

    private String getCreateSQLForCopy(Table forTable, String quotedName, boolean internalIndex) {
        StringBuilder builder = new StringBuilder("ALTER TABLE ");
        forTable.getSQL(builder, true).append(" ADD CONSTRAINT ");
        if (forTable.isHidden()) {
            builder.append("IF NOT EXISTS ");
        }
        builder.append(quotedName);
        if (this.comment != null) {
            builder.append(" COMMENT ");
            StringUtils.quoteStringSQL(builder, this.comment);
        }
        builder.append(' ').append(this.getConstraintType().getSqlName()).append('(');
        int l = this.columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.columns[i].column.getSQL(builder, true);
        }
        builder.append(')');
        if (internalIndex && this.indexOwner && forTable == this.table) {
            builder.append(" INDEX ");
            this.index.getSQL(builder, true);
        }
        return builder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    public void setColumns(IndexColumn[] columns) {
        this.columns = columns;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean isOwner) {
        this.index = index;
        this.indexOwner = isOwner;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table t, Row oldRow, Row newRow) {
    }

    @Override
    public boolean usesIndex(Index idx) {
        return idx == this.index;
    }

    @Override
    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> result = new HashSet<Column>();
        for (IndexColumn c : this.columns) {
            result.add(c.column);
        }
        return result;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
    }

    @Override
    public Index getUniqueIndex() {
        return this.index;
    }

    @Override
    public void rebuild() {
    }
}

