/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.command.ddl.SequenceOptions;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;

public class AlterSequence
extends SchemaCommand {
    private boolean ifExists;
    private Table table;
    private String sequenceName;
    private Sequence sequence;
    private SequenceOptions options;

    public AlterSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setOptions(SequenceOptions options) {
        this.options = options;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setColumn(Column column) {
        this.table = column.getTable();
        this.sequence = column.getSequence();
        if (this.sequence == null && !this.ifExists) {
            throw DbException.get(90036, column.getSQL(false));
        }
    }

    @Override
    public int update() {
        Long cache;
        Boolean cycle;
        if (this.sequence == null) {
            this.sequence = this.getSchema().findSequence(this.sequenceName);
            if (this.sequence == null) {
                if (!this.ifExists) {
                    throw DbException.get(90036, this.sequenceName);
                }
                return 0;
            }
        }
        if (this.table != null) {
            this.session.getUser().checkRight(this.table, 15);
        }
        if ((cycle = this.options.getCycle()) != null) {
            this.sequence.setCycle(cycle);
        }
        if ((cache = this.options.getCacheSize(this.session)) != null) {
            this.sequence.setCacheSize(cache);
        }
        if (this.options.isRangeSet()) {
            this.sequence.modify(this.options.getStartValue(this.session), this.options.getMinValue(this.sequence, this.session), this.options.getMaxValue(this.sequence, this.session), this.options.getIncrement(this.session));
        }
        this.sequence.flush(this.session);
        return 0;
    }

    @Override
    public int getType() {
        return 54;
    }
}

