/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IntervalUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueDate;
import org.gridgain.internal.h2.value.ValueInterval;
import org.gridgain.internal.h2.value.ValueTime;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class LocalDateTimeUtils {
    public static final Class<?> LOCAL_DATE = LocalDateTimeUtils.tryGetClass("java.time.LocalDate");
    public static final Class<?> LOCAL_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalTime");
    public static final Class<?> LOCAL_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.LocalDateTime");
    public static final Class<?> INSTANT = LocalDateTimeUtils.tryGetClass("java.time.Instant");
    public static final Class<?> OFFSET_DATE_TIME = LocalDateTimeUtils.tryGetClass("java.time.OffsetDateTime");
    private static final Class<?> ZONE_OFFSET = LocalDateTimeUtils.tryGetClass("java.time.ZoneOffset");
    public static final Class<?> PERIOD = LocalDateTimeUtils.tryGetClass("java.time.Period");
    public static final Class<?> DURATION = LocalDateTimeUtils.tryGetClass("java.time.Duration");
    private static final Method LOCAL_TIME_OF_NANO;
    private static final Method LOCAL_TIME_TO_NANO;
    private static final Method LOCAL_DATE_OF_YEAR_MONTH_DAY;
    private static final Method LOCAL_DATE_GET_YEAR;
    private static final Method LOCAL_DATE_GET_MONTH_VALUE;
    private static final Method LOCAL_DATE_GET_DAY_OF_MONTH;
    private static final Method LOCAL_DATE_AT_START_OF_DAY;
    private static final Method INSTANT_GET_EPOCH_SECOND;
    private static final Method INSTANT_GET_NANO;
    private static final Method TIMESTAMP_TO_INSTANT;
    private static final Method LOCAL_DATE_TIME_PLUS_NANOS;
    private static final Method LOCAL_DATE_TIME_TO_LOCAL_DATE;
    private static final Method LOCAL_DATE_TIME_TO_LOCAL_TIME;
    private static final Method ZONE_OFFSET_OF_TOTAL_SECONDS;
    private static final Method OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET;
    private static final Method OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME;
    private static final Method OFFSET_DATE_TIME_GET_OFFSET;
    private static final Method ZONE_OFFSET_GET_TOTAL_SECONDS;
    private static final Method PERIOD_OF;
    private static final Method PERIOD_GET_YEARS;
    private static final Method PERIOD_GET_MONTHS;
    private static final Method PERIOD_GET_DAYS;
    private static final Method DURATION_OF_SECONDS;
    private static final Method DURATION_GET_SECONDS;
    private static final Method DURATION_GET_NANO;
    private static final boolean IS_JAVA8_DATE_API_PRESENT;

    private LocalDateTimeUtils() {
    }

    public static boolean isJava8DateApiPresent() {
        return IS_JAVA8_DATE_API_PRESENT;
    }

    private static Class<?> tryGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Java 8 or later but method " + clazz.getName() + "#" + methodName + "(" + Arrays.toString(parameterTypes) + ") is missing", e);
        }
    }

    public static Object valueToLocalDate(Value value) {
        try {
            return LocalDateTimeUtils.localDateFromDateValue(((ValueDate)value.convertTo(10)).getDateValue());
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "date conversion failed");
        }
    }

    public static Object valueToLocalTime(Value value) {
        try {
            return LOCAL_TIME_OF_NANO.invoke(null, ((ValueTime)value.convertTo(9)).getNanos());
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    public static Object valueToLocalDateTime(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long dateValue = valueTimestamp.getDateValue();
        long timeNanos = valueTimestamp.getTimeNanos();
        try {
            return LocalDateTimeUtils.localDateTimeFromDateNanos(dateValue, timeNanos);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp conversion failed");
        }
    }

    public static Object valueToInstant(Value value) {
        try {
            return TIMESTAMP_TO_INSTANT.invoke((Object)value.getTimestamp(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp conversion failed");
        }
    }

    public static Object valueToOffsetDateTime(Value value) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value.convertTo(24);
        long dateValue = valueTimestampTimeZone.getDateValue();
        long timeNanos = valueTimestampTimeZone.getTimeNanos();
        try {
            Object localDateTime = LocalDateTimeUtils.localDateTimeFromDateNanos(dateValue, timeNanos);
            short timeZoneOffsetMins = valueTimestampTimeZone.getTimeZoneOffsetMins();
            int offsetSeconds = (int)TimeUnit.MINUTES.toSeconds(timeZoneOffsetMins);
            Object offset = ZONE_OFFSET_OF_TOTAL_SECONDS.invoke(null, offsetSeconds);
            return OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET.invoke(null, localDateTime, offset);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp with time zone conversion failed");
        }
    }

    public static Object valueToPeriod(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(32);
        }
        if (!DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        ValueInterval v = (ValueInterval)value;
        IntervalQualifier qualifier = v.getQualifier();
        boolean negative = v.isNegative();
        long leading = v.getLeading();
        long remaining = v.getRemaining();
        int y = Value.convertToInt(IntervalUtils.yearsFromInterval(qualifier, negative, leading, remaining), null);
        int m = Value.convertToInt(IntervalUtils.monthsFromInterval(qualifier, negative, leading, remaining), null);
        try {
            return PERIOD_OF.invoke(null, y, m, 0);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp with time zone conversion failed");
        }
    }

    public static Object valueToDuration(Value value) {
        if (!(value instanceof ValueInterval)) {
            value = value.convertTo(35);
        }
        if (DataType.isYearMonthIntervalType(value.getValueType())) {
            throw DbException.get(22018, (Throwable)null, value.getString());
        }
        BigInteger[] dr = IntervalUtils.intervalToAbsolute((ValueInterval)value).divideAndRemainder(BigInteger.valueOf(1000000000L));
        try {
            return DURATION_OF_SECONDS.invoke(null, dr[0].longValue(), dr[1].longValue());
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp with time zone conversion failed");
        }
    }

    public static Value localDateToDateValue(Object localDate) {
        try {
            return ValueDate.fromDateValue(LocalDateTimeUtils.dateValueFromLocalDate(localDate));
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "date conversion failed");
        }
    }

    public static Value localTimeToTimeValue(Object localTime) {
        try {
            return ValueTime.fromNanos((Long)LOCAL_TIME_TO_NANO.invoke(localTime, new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    public static Value localDateTimeToValue(Object localDateTime) {
        try {
            Object localDate = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(localDateTime, new Object[0]);
            long dateValue = LocalDateTimeUtils.dateValueFromLocalDate(localDate);
            long timeNanos = LocalDateTimeUtils.timeNanosFromLocalDateTime(localDateTime);
            return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "local date time conversion failed");
        }
    }

    public static Value instantToValue(Object instant) {
        try {
            long epochSecond = (Long)INSTANT_GET_EPOCH_SECOND.invoke(instant, new Object[0]);
            int nano = (Integer)INSTANT_GET_NANO.invoke(instant, new Object[0]);
            long absoluteDay = epochSecond / 86400L;
            if (epochSecond < 0L && absoluteDay * 86400L != epochSecond) {
                --absoluteDay;
            }
            long timeNanos = (epochSecond - absoluteDay * 86400L) * 1000000000L + (long)nano;
            return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay), timeNanos, (short)0);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "instant conversion failed");
        }
    }

    public static ValueTimestampTimeZone offsetDateTimeToValue(Object offsetDateTime) {
        try {
            Object localDateTime = OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME.invoke(offsetDateTime, new Object[0]);
            Object localDate = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(localDateTime, new Object[0]);
            Object zoneOffset = OFFSET_DATE_TIME_GET_OFFSET.invoke(offsetDateTime, new Object[0]);
            long dateValue = LocalDateTimeUtils.dateValueFromLocalDate(localDate);
            long timeNanos = LocalDateTimeUtils.timeNanosFromLocalDateTime(localDateTime);
            short timeZoneOffsetMins = LocalDateTimeUtils.zoneOffsetToOffsetMinute(zoneOffset);
            return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, timeZoneOffsetMins);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    private static long dateValueFromLocalDate(Object localDate) throws IllegalAccessException, InvocationTargetException {
        int year = (Integer)LOCAL_DATE_GET_YEAR.invoke(localDate, new Object[0]);
        int month = (Integer)LOCAL_DATE_GET_MONTH_VALUE.invoke(localDate, new Object[0]);
        int day = (Integer)LOCAL_DATE_GET_DAY_OF_MONTH.invoke(localDate, new Object[0]);
        return DateTimeUtils.dateValue(year, month, day);
    }

    private static long timeNanosFromLocalDateTime(Object localDateTime) throws IllegalAccessException, InvocationTargetException {
        Object localTime = LOCAL_DATE_TIME_TO_LOCAL_TIME.invoke(localDateTime, new Object[0]);
        return (Long)LOCAL_TIME_TO_NANO.invoke(localTime, new Object[0]);
    }

    private static short zoneOffsetToOffsetMinute(Object zoneOffset) throws IllegalAccessException, InvocationTargetException {
        int totalSeconds = (Integer)ZONE_OFFSET_GET_TOTAL_SECONDS.invoke(zoneOffset, new Object[0]);
        return (short)TimeUnit.SECONDS.toMinutes(totalSeconds);
    }

    private static Object localDateFromDateValue(long dateValue) throws IllegalAccessException, InvocationTargetException {
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        int month = DateTimeUtils.monthFromDateValue(dateValue);
        int day = DateTimeUtils.dayFromDateValue(dateValue);
        try {
            return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, year, month, day);
        }
        catch (InvocationTargetException e) {
            if (year <= 1500 && (year & 3) == 0 && month == 2 && day == 29) {
                return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, year, 3, 1);
            }
            throw e;
        }
    }

    private static Object localDateTimeFromDateNanos(long dateValue, long timeNanos) throws IllegalAccessException, InvocationTargetException {
        Object localDate = LocalDateTimeUtils.localDateFromDateValue(dateValue);
        Object localDateTime = LOCAL_DATE_AT_START_OF_DAY.invoke(localDate, new Object[0]);
        return LOCAL_DATE_TIME_PLUS_NANOS.invoke(localDateTime, timeNanos);
    }

    public static ValueInterval periodToValue(Object period) {
        try {
            IntervalQualifier qualifier;
            int days = (Integer)PERIOD_GET_DAYS.invoke(period, new Object[0]);
            if (days != 0) {
                throw DbException.getInvalidValueException("Period.days", days);
            }
            int years = (Integer)PERIOD_GET_YEARS.invoke(period, new Object[0]);
            int months = (Integer)PERIOD_GET_MONTHS.invoke(period, new Object[0]);
            boolean negative = false;
            long leading = 0L;
            long remaining = 0L;
            if (years == 0) {
                if ((long)months == 0L) {
                    qualifier = IntervalQualifier.YEAR_TO_MONTH;
                } else {
                    qualifier = IntervalQualifier.MONTH;
                    leading = months;
                    if (leading < 0L) {
                        leading = -leading;
                        negative = true;
                    }
                }
            } else if ((long)months == 0L) {
                qualifier = IntervalQualifier.YEAR;
                leading = years;
                if (leading < 0L) {
                    leading = -leading;
                    negative = true;
                }
            } else {
                qualifier = IntervalQualifier.YEAR_TO_MONTH;
                leading = years * 12 + months;
                if (leading < 0L) {
                    leading = -leading;
                    negative = true;
                }
                remaining = leading % 12L;
                leading /= 12L;
            }
            return ValueInterval.from(qualifier, negative, leading, remaining);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "interval conversion failed");
        }
    }

    public static ValueInterval durationToValue(Object duration) {
        try {
            long seconds = (Long)DURATION_GET_SECONDS.invoke(duration, new Object[0]);
            int nano = (Integer)DURATION_GET_NANO.invoke(duration, new Object[0]);
            boolean negative = seconds < 0L;
            seconds = Math.abs(seconds);
            if (negative && nano != 0) {
                nano = 1000000000 - nano;
                --seconds;
            }
            return ValueInterval.from(IntervalQualifier.SECOND, negative, seconds, nano);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "interval conversion failed");
        }
    }

    static {
        boolean bl = IS_JAVA8_DATE_API_PRESENT = LOCAL_DATE != null && LOCAL_TIME != null && LOCAL_DATE_TIME != null && INSTANT != null && OFFSET_DATE_TIME != null && ZONE_OFFSET != null && PERIOD != null && DURATION != null;
        if (IS_JAVA8_DATE_API_PRESENT) {
            LOCAL_TIME_OF_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "ofNanoOfDay", Long.TYPE);
            LOCAL_TIME_TO_NANO = LocalDateTimeUtils.getMethod(LOCAL_TIME, "toNanoOfDay", new Class[0]);
            LOCAL_DATE_OF_YEAR_MONTH_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            LOCAL_DATE_GET_YEAR = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getYear", new Class[0]);
            LOCAL_DATE_GET_MONTH_VALUE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getMonthValue", new Class[0]);
            LOCAL_DATE_GET_DAY_OF_MONTH = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getDayOfMonth", new Class[0]);
            LOCAL_DATE_AT_START_OF_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "atStartOfDay", new Class[0]);
            INSTANT_GET_EPOCH_SECOND = LocalDateTimeUtils.getMethod(INSTANT, "getEpochSecond", new Class[0]);
            INSTANT_GET_NANO = LocalDateTimeUtils.getMethod(INSTANT, "getNano", new Class[0]);
            TIMESTAMP_TO_INSTANT = LocalDateTimeUtils.getMethod(Timestamp.class, "toInstant", new Class[0]);
            LOCAL_DATE_TIME_PLUS_NANOS = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "plusNanos", Long.TYPE);
            LOCAL_DATE_TIME_TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalDate", new Class[0]);
            LOCAL_DATE_TIME_TO_LOCAL_TIME = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalTime", new Class[0]);
            ZONE_OFFSET_OF_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "ofTotalSeconds", Integer.TYPE);
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "toLocalDateTime", new Class[0]);
            OFFSET_DATE_TIME_GET_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "getOffset", new Class[0]);
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "of", LOCAL_DATE_TIME, ZONE_OFFSET);
            ZONE_OFFSET_GET_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "getTotalSeconds", new Class[0]);
            PERIOD_OF = LocalDateTimeUtils.getMethod(PERIOD, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            PERIOD_GET_YEARS = LocalDateTimeUtils.getMethod(PERIOD, "getYears", new Class[0]);
            PERIOD_GET_MONTHS = LocalDateTimeUtils.getMethod(PERIOD, "getMonths", new Class[0]);
            PERIOD_GET_DAYS = LocalDateTimeUtils.getMethod(PERIOD, "getDays", new Class[0]);
            DURATION_OF_SECONDS = LocalDateTimeUtils.getMethod(DURATION, "ofSeconds", Long.TYPE, Long.TYPE);
            DURATION_GET_SECONDS = LocalDateTimeUtils.getMethod(DURATION, "getSeconds", new Class[0]);
            DURATION_GET_NANO = LocalDateTimeUtils.getMethod(DURATION, "getNano", new Class[0]);
        } else {
            LOCAL_TIME_OF_NANO = null;
            LOCAL_TIME_TO_NANO = null;
            LOCAL_DATE_OF_YEAR_MONTH_DAY = null;
            LOCAL_DATE_GET_YEAR = null;
            LOCAL_DATE_GET_MONTH_VALUE = null;
            LOCAL_DATE_GET_DAY_OF_MONTH = null;
            LOCAL_DATE_AT_START_OF_DAY = null;
            INSTANT_GET_EPOCH_SECOND = null;
            INSTANT_GET_NANO = null;
            TIMESTAMP_TO_INSTANT = null;
            LOCAL_DATE_TIME_PLUS_NANOS = null;
            LOCAL_DATE_TIME_TO_LOCAL_DATE = null;
            LOCAL_DATE_TIME_TO_LOCAL_TIME = null;
            ZONE_OFFSET_OF_TOTAL_SECONDS = null;
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = null;
            OFFSET_DATE_TIME_GET_OFFSET = null;
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = null;
            ZONE_OFFSET_GET_TOTAL_SECONDS = null;
            PERIOD_OF = null;
            PERIOD_GET_YEARS = null;
            PERIOD_GET_MONTHS = null;
            PERIOD_GET_DAYS = null;
            DURATION_OF_SECONDS = null;
            DURATION_GET_SECONDS = null;
            DURATION_GET_NANO = null;
        }
    }
}

