/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.tools.RunScript;
import org.gridgain.internal.h2.util.Tool;

public class CreateCluster
extends Tool {
    public static void main(String ... args) throws SQLException {
        new CreateCluster().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String urlSource = null;
        String urlTarget = null;
        String user = "";
        String password = "";
        String serverList = null;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-urlSource")) {
                urlSource = args[++i];
                continue;
            }
            if (arg.equals("-urlTarget")) {
                urlTarget = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-serverList")) {
                serverList = args[++i];
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (urlSource == null || urlTarget == null || serverList == null) {
            this.showUsage();
            throw new SQLException("Source URL, target URL, or server list not set");
        }
        CreateCluster.process(urlSource, urlTarget, user, password, serverList);
    }

    public void execute(String urlSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        CreateCluster.process(urlSource, urlTarget, user, password, serverList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(String urlSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        Driver.load();
        try (Connection connSource = DriverManager.getConnection(urlSource + ";CLUSTER=''", user, password);
             Statement statSource = connSource.createStatement();){
            statSource.execute("SET EXCLUSIVE 2");
            try {
                CreateCluster.performTransfer(statSource, urlTarget, user, password, serverList);
            }
            finally {
                statSource.execute("SET EXCLUSIVE FALSE");
            }
        }
    }

    private static void performTransfer(Statement statSource, String urlTarget, String user, String password, String serverList) throws SQLException {
        try (Connection connTarget = DriverManager.getConnection(urlTarget + ";CLUSTER=''", user, password);
             Statement statTarget = connTarget.createStatement();){
            statTarget.execute("DROP ALL OBJECTS DELETE FILES");
        }
        try {
            var6_7 = null;
            try (PipedReader pipeReader = new PipedReader();){
                Future<?> threadFuture = CreateCluster.startWriter(pipeReader, statSource);
                try (Connection connTarget = DriverManager.getConnection(urlTarget, user, password);
                     Statement statTarget = connTarget.createStatement();){
                    RunScript.execute(connTarget, pipeReader);
                    try {
                        threadFuture.get();
                    }
                    catch (ExecutionException ex) {
                        throw new SQLException(ex.getCause());
                    }
                    catch (InterruptedException ex) {
                        throw new SQLException(ex);
                    }
                    statSource.executeUpdate("SET CLUSTER '" + serverList + "'");
                    statTarget.executeUpdate("SET CLUSTER '" + serverList + "'");
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    private static Future<?> startWriter(PipedReader pipeReader, final Statement statSource) throws IOException {
        ExecutorService thread = Executors.newFixedThreadPool(1);
        final PipedWriter pipeWriter = new PipedWriter(pipeReader);
        Future<?> threadFuture = thread.submit(new Runnable(){

            @Override
            public void run() {
                try (PipedWriter writer = pipeWriter;
                     ResultSet rs = statSource.executeQuery("SCRIPT");){
                    while (rs.next()) {
                        writer.write(rs.getString(1) + "\n");
                    }
                }
                catch (IOException | SQLException ex) {
                    throw new IllegalStateException("Producing script from the source DB is failing.", ex);
                }
            }
        });
        thread.shutdown();
        return threadFuture;
    }
}

