/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.Collections;
import java.util.List;
import org.gridgain.internal.h2.command.ddl.CreateTableData;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbSettings;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.StringUtils;

public abstract class TableBase
extends Table {
    private final String tableEngine;
    private final List<String> tableEngineParams;
    private final boolean globalTemporary;

    public static int getMainIndexColumn(IndexType indexType, IndexColumn[] cols) {
        if (!indexType.isPrimaryKey() || cols.length != 1) {
            return -1;
        }
        IndexColumn first = cols[0];
        if (first.sortType != 0) {
            return -1;
        }
        switch (first.column.getType().getValueType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return first.column.getColumnId();
            }
        }
        return -1;
    }

    public TableBase(CreateTableData data) {
        super(data.schema, data.id, data.tableName, data.persistIndexes, data.persistData);
        this.tableEngine = data.tableEngine;
        this.globalTemporary = data.globalTemporary;
        this.tableEngineParams = data.tableEngineParams != null ? data.tableEngineParams : Collections.emptyList();
        this.setTemporary(data.temporary);
        this.setColumns(data.columns.toArray(new Column[0]));
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP TABLE IF EXISTS ");
        this.getSQL(builder, true).append(" CASCADE");
        return builder.toString();
    }

    @Override
    public String getCreateSQL() {
        int i;
        Database db = this.getDatabase();
        if (db == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder("CREATE ");
        if (this.isTemporary()) {
            if (this.isGlobalTemporary()) {
                buff.append("GLOBAL ");
            } else {
                buff.append("LOCAL ");
            }
            buff.append("TEMPORARY ");
        } else if (this.isPersistIndexes()) {
            buff.append("CACHED ");
        } else {
            buff.append("MEMORY ");
        }
        buff.append("TABLE ");
        if (this.isHidden) {
            buff.append("IF NOT EXISTS ");
        }
        this.getSQL(buff, true);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append("(\n    ");
        int l = this.columns.length;
        for (i = 0; i < l; ++i) {
            if (i > 0) {
                buff.append(",\n    ");
            }
            buff.append(this.columns[i].getCreateSQL());
        }
        buff.append("\n)");
        if (this.tableEngine != null) {
            DbSettings s = db.getSettings();
            String d = s.defaultTableEngine;
            if (d == null && s.mvStore) {
                d = MVTableEngine.class.getName();
            }
            if (d == null || !this.tableEngine.endsWith(d)) {
                buff.append("\nENGINE ");
                StringUtils.quoteIdentifier(buff, this.tableEngine);
            }
        }
        if (!this.tableEngineParams.isEmpty()) {
            buff.append("\nWITH ");
            l = this.tableEngineParams.size();
            for (i = 0; i < l; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                StringUtils.quoteIdentifier(buff, this.tableEngineParams.get(i));
            }
        }
        if (!this.isPersistIndexes() && !this.isPersistData()) {
            buff.append("\nNOT PERSISTENT");
        }
        if (this.isHidden) {
            buff.append("\nHIDDEN");
        }
        return buff.toString();
    }

    @Override
    public boolean isGlobalTemporary() {
        return this.globalTemporary;
    }
}

