/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class AggregateDataCollecting
extends AggregateData
implements Iterable<Value> {
    private final boolean distinct;
    Collection<Value> values;
    private Value shared;
    private H2MemoryTracker tracker;

    AggregateDataCollecting(boolean distinct) {
        this.distinct = distinct;
    }

    private AggregateDataCollecting(boolean distinct, Collection<Value> values, Value shared) {
        this.distinct = distinct;
        this.values = values;
        this.shared = shared;
    }

    @Override
    void add(Session ses, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        AbstractCollection c = this.values;
        if (c == null) {
            c = this.distinct ? new TreeSet<Value>(ses.getDatabase().getCompareMode()) : new ArrayList();
            this.values = c;
        }
        if (this.tracker == null && ses.memoryTracker() != null) {
            this.tracker = ses.memoryTracker().createChildTracker();
        }
        if (c.add(v) && this.tracker != null) {
            long size = this.distinct ? 40L : 8L;
            this.tracker.reserve(size += (long)v.getMemory());
        }
    }

    @Override
    public void mergeAggregate(Session ses, AggregateData agg) {
        assert (agg != null);
        assert (agg instanceof AggregateDataCollecting) : agg.getClass();
        AggregateDataCollecting a = (AggregateDataCollecting)agg;
        assert (this.distinct == a.distinct);
        assert (this.shared == a.shared);
        if (this.values == null) {
            this.values = a.values;
        } else if (a.values != null) {
            this.values.addAll(a.values);
        }
    }

    @Override
    Value getValue(Database database, int dataType) {
        return null;
    }

    int getCount() {
        return this.values != null ? this.values.size() : 0;
    }

    Value[] getArray() {
        Collection<Value> values = this.values;
        if (values == null) {
            return null;
        }
        return values.toArray(new Value[0]);
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values != null ? this.values.iterator() : Collections.emptyIterator();
    }

    void setSharedArgument(Value shared) {
        if (this.shared == null) {
            this.shared = shared;
        } else if (!this.shared.equals(shared)) {
            throw DbException.get(90008, "Inverse distribution function argument", this.shared.getTraceSQL() + "<>" + shared.getTraceSQL());
        }
    }

    public Value getSharedArgument() {
        return this.shared;
    }

    @Override
    public void cleanup(Session ses) {
        if (this.values != null) {
            this.values = null;
        }
        if (this.tracker != null) {
            this.tracker.release(this.tracker.reserved());
        }
    }

    @Override
    public long getMemory() {
        return this.tracker.reserved();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Collection<Value> values() {
        return this.values;
    }

    public static AggregateDataCollecting from(boolean distinct, Collection<Value> values, Value shared) {
        return new AggregateDataCollecting(distinct, values, shared);
    }
}

