/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCollecting;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataCount;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataDefault;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataDistinctWithCounts;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataEnvelope;
import org.gridgain.internal.h2.expression.aggregate.AggregateDataSelectivity;
import org.gridgain.internal.h2.expression.aggregate.AggregateType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.Value;

public abstract class AggregateData {
    static AggregateData create(AggregateType aggregateType, boolean distinct, int dataType) {
        switch (aggregateType) {
            case COUNT_ALL: {
                return new AggregateDataCount(true);
            }
            case COUNT: {
                if (distinct) break;
                return new AggregateDataCount(false);
            }
            case LISTAGG: 
            case ARRAY_AGG: 
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: 
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: 
            case MEDIAN: {
                break;
            }
            case MIN: 
            case MAX: 
            case BIT_OR: 
            case BIT_AND: 
            case ANY: 
            case EVERY: {
                return new AggregateDataDefault(aggregateType, dataType);
            }
            case SUM: 
            case AVG: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                if (distinct) break;
                return new AggregateDataDefault(aggregateType, dataType);
            }
            case SELECTIVITY: {
                return new AggregateDataSelectivity(distinct);
            }
            case HISTOGRAM: {
                return new AggregateDataDistinctWithCounts(false, 10000);
            }
            case MODE: {
                return new AggregateDataDistinctWithCounts(true, Integer.MAX_VALUE);
            }
            case ENVELOPE: {
                return new AggregateDataEnvelope();
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)aggregateType));
            }
        }
        return new AggregateDataCollecting(distinct);
    }

    abstract void add(Session var1, Value var2);

    public abstract void mergeAggregate(Session var1, AggregateData var2);

    abstract Value getValue(Database var1, int var2);

    public void cleanup(Session ses) {
    }

    public abstract long getMemory();
}

