/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;

public class TruncateTable
extends DefineCommand {
    private Table table;
    private boolean restart;

    public TruncateTable(Session session) {
        super(session);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setRestart(boolean restart) {
        this.restart = restart;
    }

    @Override
    public int update() {
        this.session.commit(true);
        if (!this.table.canTruncate()) {
            throw DbException.get(90106, this.table.getSQL(false));
        }
        this.session.getUser().checkRight(this.table, 2);
        this.table.lock(this.session, true, true);
        this.table.truncate(this.session);
        if (this.restart) {
            for (Column column : this.table.getColumns()) {
                long min;
                Sequence sequence = column.getSequence();
                if (sequence == null || (min = sequence.getMinValue()) == sequence.getCurrentValue()) continue;
                sequence.modify(min, null, null, null);
                this.session.getDatabase().updateMeta(this.session, sequence);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return 53;
    }
}

