/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.store.FileStoreInputStream;
import org.gridgain.internal.h2.store.RangeInputStream;
import org.gridgain.internal.h2.store.RangeReader;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.IOUtils;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.SmallLRUCache;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLobDb;

public class ValueLob
extends Value {
    private static final int BLOCK_COMPARISON_SIZE = 512;
    private static int dirCounter;
    private final int valueType;
    private TypeInfo type;
    private final long precision;
    private final DataHandler handler;
    private int tableId;
    private final int objectId;
    private String fileName;
    private boolean linked;
    private int hash;
    private final boolean compressed;

    private static void rangeCheckUnknown(long zeroBasedOffset, long length) {
        if (zeroBasedOffset < 0L) {
            throw DbException.getInvalidValueException("offset", zeroBasedOffset + 1L);
        }
        if (length < 0L) {
            throw DbException.getInvalidValueException("length", length);
        }
    }

    static InputStream rangeInputStream(InputStream inputStream, long oneBasedOffset, long length, long dataSize) {
        if (dataSize > 0L) {
            ValueLob.rangeCheck(oneBasedOffset - 1L, length, dataSize);
        } else {
            ValueLob.rangeCheckUnknown(oneBasedOffset - 1L, length);
        }
        try {
            return new RangeInputStream(inputStream, oneBasedOffset - 1L, length);
        }
        catch (IOException e) {
            throw DbException.getInvalidValueException("offset", oneBasedOffset);
        }
    }

    static Reader rangeReader(Reader reader, long oneBasedOffset, long length, long dataSize) {
        if (dataSize > 0L) {
            ValueLob.rangeCheck(oneBasedOffset - 1L, length, dataSize);
        } else {
            ValueLob.rangeCheckUnknown(oneBasedOffset - 1L, length);
        }
        try {
            return new RangeReader(reader, oneBasedOffset - 1L, length);
        }
        catch (IOException e) {
            throw DbException.getInvalidValueException("offset", oneBasedOffset);
        }
    }

    /*
     * Exception decompiling
     */
    static int compare(Value v1, Value v2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 84[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ValueLob(int type, DataHandler handler, String fileName, int tableId, int objectId, boolean linked, long precision, boolean compressed) {
        this.valueType = type;
        this.handler = handler;
        this.fileName = fileName;
        this.tableId = tableId;
        this.objectId = objectId;
        this.linked = linked;
        this.precision = precision;
        this.compressed = compressed;
    }

    private static String getFileName(DataHandler handler, int tableId, int objectId) {
        if (tableId == 0 && objectId == 0) {
            DbException.throwInternalError("0 LOB");
        }
        String table = tableId < 0 ? ".temp" : ".t" + tableId;
        return ValueLob.getFileNamePrefix(handler.getDatabasePath(), objectId) + table + ".lob.db";
    }

    public static ValueLob openLinked(int type, DataHandler handler, int tableId, int objectId, long precision, boolean compression) {
        String fileName = ValueLob.getFileName(handler, tableId, objectId);
        return new ValueLob(type, handler, fileName, tableId, objectId, true, precision, compression);
    }

    public static ValueLob openUnlinked(int type, DataHandler handler, int tableId, int objectId, long precision, boolean compression, String fileName) {
        return new ValueLob(type, handler, fileName, tableId, objectId, false, precision, compression);
    }

    private static String getFileNamePrefix(String path, int objectId) {
        int f = objectId % SysProperties.LOB_FILES_PER_DIRECTORY;
        String name = f > 0 ? SysProperties.FILE_SEPARATOR + objectId : "";
        objectId /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (objectId > 0) {
            f = objectId % SysProperties.LOB_FILES_PER_DIRECTORY;
            name = SysProperties.FILE_SEPARATOR + f + ".lobs.db" + name;
            objectId /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        name = FileUtils.toRealPath(path + ".lobs.db" + name);
        return name;
    }

    private static int getNewObjectId(DataHandler h) {
        int fileId;
        String dir;
        String path = h.getDatabasePath();
        if (path != null && path.isEmpty()) {
            path = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
        }
        int newId = 0;
        int lobsPerDir = SysProperties.LOB_FILES_PER_DIRECTORY;
        while (true) {
            dir = ValueLob.getFileNamePrefix(path, newId);
            String[] list = ValueLob.getFileList(h, dir);
            int fileCount = 0;
            boolean[] used = new boolean[lobsPerDir];
            for (String name : list) {
                int id;
                if (!name.endsWith(".db")) continue;
                name = FileUtils.getName(name);
                String n = name.substring(0, name.indexOf(46));
                try {
                    id = Integer.parseInt(n);
                }
                catch (NumberFormatException e) {
                    id = -1;
                }
                if (id <= 0) continue;
                ++fileCount;
                used[id % lobsPerDir] = true;
            }
            fileId = -1;
            if (fileCount < lobsPerDir) {
                for (int i = 1; i < lobsPerDir; ++i) {
                    if (used[i]) continue;
                    fileId = i;
                    break;
                }
            }
            if (fileId > 0) break;
            if (newId > Integer.MAX_VALUE / lobsPerDir) {
                newId = 0;
                dirCounter = MathUtils.randomInt(lobsPerDir - 1) * lobsPerDir;
                continue;
            }
            int dirId = dirCounter++ / (lobsPerDir - 1) + 1;
            newId *= lobsPerDir;
            newId += dirId * lobsPerDir;
        }
        ValueLob.invalidateFileList(h, dir);
        return newId += fileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateFileList(DataHandler h, String dir) {
        SmallLRUCache<String, String[]> cache = h.getLobFileListCache();
        if (cache != null) {
            SmallLRUCache<String, String[]> smallLRUCache = cache;
            synchronized (smallLRUCache) {
                cache.remove(dir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFileList(DataHandler h, String dir) {
        String[] list;
        SmallLRUCache<String, String[]> cache = h.getLobFileListCache();
        if (cache == null) {
            list = FileUtils.newDirectoryStream(dir).toArray(new String[0]);
        } else {
            SmallLRUCache<String, String[]> smallLRUCache = cache;
            synchronized (smallLRUCache) {
                list = (String[])cache.get(dir);
                if (list == null) {
                    list = FileUtils.newDirectoryStream(dir).toArray(new String[0]);
                    cache.put(dir, list);
                }
            }
        }
        return list;
    }

    @Override
    protected Value convertTo(int t, Mode mode, Object column, ExtTypeInfo extTypeInfo) {
        if (t == this.valueType) {
            return this;
        }
        if (t == 16) {
            return ValueLobDb.createTempClob(this.getReader(), -1L, this.handler);
        }
        if (t == 15) {
            return ValueLobDb.createTempBlob(this.getInputStream(), -1L, this.handler);
        }
        return super.convertTo(t, mode, column, null);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void remove() {
        ValueLob.deleteFile(this.handler, this.fileName);
    }

    @Override
    public Value copy(DataHandler h, int tabId) {
        if (this.linked) {
            ValueLob copy = new ValueLob(this.valueType, this.handler, this.fileName, this.tableId, ValueLob.getNewObjectId(h), this.linked, this.precision, this.compressed);
            copy.hash = this.hash;
            copy.tableId = tabId;
            String live = ValueLob.getFileName(h, copy.tableId, copy.objectId);
            ValueLob.copyFileTo(h, this.fileName, live);
            copy.fileName = live;
            copy.linked = true;
            return copy;
        }
        if (!this.linked) {
            this.tableId = tabId;
            String live = ValueLob.getFileName(h, this.tableId, this.objectId);
            ValueLob.renameFile(h, this.fileName, live);
            this.fileName = live;
            this.linked = true;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            this.type = type = new TypeInfo(this.valueType, this.precision, 0, MathUtils.convertLongToInt(this.precision), null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public String getString() {
        int len = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.valueType == 16) {
                return IOUtils.readStringAndClose(this.getReader(), len);
            }
            byte[] buff = IOUtils.readBytesAndClose(this.getInputStream(), len);
            return StringUtils.convertBytesToHex(buff);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.fileName);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.valueType == 16) {
            return super.getBytes();
        }
        byte[] data = this.getBytesNoCopy();
        return Utils.cloneByteArray(data);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.valueType == 16) {
            return super.getBytesNoCopy();
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.fileName);
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.valueType == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        return ValueLob.compare(this, v);
    }

    @Override
    public Object getObject() {
        if (this.valueType == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long oneBasedOffset, long length) {
        return ValueLob.rangeReader(this.getReader(), oneBasedOffset, length, this.valueType == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        FileStore store = this.handler.openFile(this.fileName, "r", true);
        boolean alwaysClose = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(store, this.handler, this.compressed, alwaysClose), 4096);
    }

    @Override
    public InputStream getInputStream(long oneBasedOffset, long length) {
        FileStore store = this.handler.openFile(this.fileName, "r", true);
        boolean alwaysClose = SysProperties.lobCloseBetweenReads;
        BufferedInputStream inputStream = new BufferedInputStream(new FileStoreInputStream(store, this.handler, this.compressed, alwaysClose), 4096);
        return ValueLob.rangeInputStream(inputStream, oneBasedOffset, length, store.length());
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        long p = this.precision;
        if (p > Integer.MAX_VALUE || p <= 0L) {
            p = -1L;
        }
        if (this.valueType == 15) {
            prep.setBinaryStream(parameterIndex, this.getInputStream(), (int)p);
        } else {
            prep.setCharacterStream(parameterIndex, this.getReader(), (int)p);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        if (this.valueType == 16) {
            StringUtils.quoteStringSQL(builder, this.getString());
        } else {
            builder.append("X'");
            StringUtils.convertBytesToHex(builder, this.getBytes()).append('\'');
        }
        return builder;
    }

    @Override
    public String getTraceSQL() {
        StringBuilder buff = new StringBuilder();
        if (this.valueType == 16) {
            buff.append("SPACE(").append(this.precision);
        } else {
            buff.append("CAST(REPEAT('00', ").append(this.precision).append(") AS BINARY");
        }
        buff.append(" /* ").append(this.fileName).append(" */)");
        return buff.toString();
    }

    @Override
    public byte[] getSmall() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ValueLob) {
            ValueLob o = (ValueLob)other;
            return this.valueType == o.valueType && this.compareTypeSafe(o, null) == 0;
        }
        return false;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler handler, String fileName) {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler handler, String oldName, String newName) {
        Object object = handler.getLobSyncObject();
        synchronized (object) {
            FileUtils.move(oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileTo(DataHandler h, String sourceFileName, String targetFileName) {
        Object object = h.getLobSyncObject();
        synchronized (object) {
            try {
                IOUtils.copyFiles(sourceFileName, targetFileName);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
    }

    @Override
    public int getMemory() {
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        ValueLobDb lob = this.valueType == 16 ? ValueLobDb.createTempClob(this.getReader(), this.precision, this.handler) : ValueLobDb.createTempBlob(this.getInputStream(), this.precision, this.handler);
        return lob;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        if (this.precision <= precision) {
            return this;
        }
        ValueLobDb lob = this.valueType == 16 ? ValueLobDb.createTempClob(this.getReader(), precision, this.handler) : ValueLobDb.createTempBlob(this.getInputStream(), precision, this.handler);
        return lob;
    }
}

