/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueCollectionBase;

public class ValueArray
extends ValueCollectionBase {
    private static final Object EMPTY = ValueArray.get(new Value[0]);
    private final Class<?> componentType;

    private ValueArray(Class<?> componentType, Value[] list) {
        super(list);
        this.componentType = componentType;
    }

    public static ValueArray get(Value[] list) {
        return new ValueArray(Object.class, list);
    }

    public static ValueArray get(Class<?> componentType, Value[] list) {
        return new ValueArray(componentType, list);
    }

    public static ValueArray getEmpty() {
        return (ValueArray)EMPTY;
    }

    @Override
    public int getValueType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.values[i].getString());
        }
        return builder.append(']').toString();
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        ValueArray v = (ValueArray)o;
        if (this.values == v.values) {
            return 0;
        }
        int l = this.values.length;
        int ol = v.values.length;
        int len = Math.min(l, ol);
        for (int i = 0; i < len; ++i) {
            Value v1 = this.values[i];
            Value v2 = v.values[i];
            int comp = v1.compareTo(v2, null, mode);
            if (comp == 0) continue;
            return comp;
        }
        return Integer.compare(l, ol);
    }

    @Override
    public Object getObject() {
        int len = this.values.length;
        Object[] list = (Object[])Array.newInstance(this.componentType, len);
        for (int i = 0; i < len; ++i) {
            int type;
            Value value = this.values[i];
            list[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((type = value.getValueType()) == 2 || type == 3) ? Integer.valueOf(value.getInt()) : value.getObject();
        }
        return list;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setArray(parameterIndex, prep.getConnection().createArrayOf("NULL", (Object[])this.getObject()));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("ARRAY [");
        int length = this.values.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.values[i].getSQL(builder);
        }
        return builder.append(']');
    }

    @Override
    public String getTraceSQL() {
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.values.length; ++i) {
            Value v;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((v = this.values[i]) == null ? "null" : v.getTraceSQL());
        }
        return builder.append(']').toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ValueArray)) {
            return false;
        }
        ValueArray v = (ValueArray)other;
        if (this.values == v.values) {
            return true;
        }
        int len = this.values.length;
        if (len != v.values.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.values[i].equals(v.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Value convertPrecision(long precision, boolean force) {
        int i;
        if (!force) {
            return this;
        }
        int length = this.values.length;
        Value[] newValues = new Value[length];
        boolean modified = false;
        for (i = 0; i < length; ++i) {
            Value old = this.values[i];
            Value v = old.convertPrecision(precision, true);
            if (v != old) {
                modified = true;
            }
            if ((precision -= Math.max(1L, v.getType().getPrecision())) < 0L) break;
            newValues[i] = v;
        }
        if (i < length) {
            return ValueArray.get(this.componentType, Arrays.copyOf(newValues, i));
        }
        return modified ? ValueArray.get(this.componentType, newValues) : this;
    }
}

