/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;

public class MathUtils {
    static SecureRandom cachedSecureRandom;
    static volatile boolean seeded;

    private MathUtils() {
    }

    public static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    public static long roundUpLong(long x, long blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1L & -blockSizePowerOf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block10: {
            if (cachedSecureRandom != null) {
                return cachedSecureRandom;
            }
            try {
                cachedSecureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
                            byte[] seed = sr.generateSeed(20);
                            SecureRandom secureRandom = cachedSecureRandom;
                            synchronized (secureRandom) {
                                cachedSecureRandom.setSeed(seed);
                                seeded = true;
                            }
                        }
                        catch (Exception e) {
                            MathUtils.warn("SecureRandom", e);
                        }
                    }
                };
                try {
                    Thread t = new Thread(runnable, "Generate Seed");
                    t.setDaemon(true);
                    t.start();
                    Thread.yield();
                    try {
                        t.join(400L);
                    }
                    catch (InterruptedException e) {
                        MathUtils.warn("InterruptedException", e);
                    }
                    if (seeded) break block10;
                    byte[] seed = MathUtils.generateAlternativeSeed();
                    SecureRandom secureRandom = cachedSecureRandom;
                    synchronized (secureRandom) {
                        cachedSecureRandom.setSeed(seed);
                    }
                }
                catch (SecurityException e) {
                    runnable.run();
                    MathUtils.generateAlternativeSeed();
                }
            }
            catch (Exception e) {
                MathUtils.warn("SecureRandom", e);
                cachedSecureRandom = new SecureRandom();
            }
        }
        return cachedSecureRandom;
    }

    public static byte[] generateAlternativeSeed() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeLong(System.currentTimeMillis());
            out.writeLong(System.nanoTime());
            out.writeInt(new Object().hashCode());
            Runtime runtime = Runtime.getRuntime();
            out.writeLong(runtime.freeMemory());
            out.writeLong(runtime.maxMemory());
            out.writeLong(runtime.totalMemory());
            try {
                String s = System.getProperties().toString();
                out.writeInt(s.length());
                out.write(s.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                MathUtils.warn("generateAlternativeSeed", e);
            }
            try {
                Class<?> inetAddressClass = Class.forName("java.net.InetAddress");
                Object localHost = inetAddressClass.getMethod("getLocalHost", new Class[0]).invoke(null, new Object[0]);
                String hostName = inetAddressClass.getMethod("getHostName", new Class[0]).invoke(localHost, new Object[0]).toString();
                out.writeUTF(hostName);
                Object[] list = (Object[])inetAddressClass.getMethod("getAllByName", String.class).invoke(null, hostName);
                Method getAddress = inetAddressClass.getMethod("getAddress", new Class[0]);
                for (Object o : list) {
                    out.write((byte[])getAddress.invoke(o, new Object[0]));
                }
            }
            catch (Throwable inetAddressClass) {
                // empty catch block
            }
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long end = System.currentTimeMillis();
                while (end == System.currentTimeMillis()) {
                    ++i;
                }
                out.writeInt(i);
            }
            out.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            MathUtils.warn("generateAlternativeSeed", e);
            return new byte[1];
        }
    }

    static void warn(String s, Throwable t) {
        System.out.println("Warning: " + s);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static int nextPowerOf2(int x) throws IllegalArgumentException {
        if (x == 0) {
            return 1;
        }
        if (x < 0 || x > 0x40000000) {
            throw new IllegalArgumentException("Argument out of range [0x0-0x40000000]. Argument was: " + x);
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return ++x;
    }

    public static int convertLongToInt(long l) {
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static long secureRandomLong() {
        return MathUtils.getSecureRandom().nextLong();
    }

    public static void randomBytes(byte[] bytes) {
        ThreadLocalRandom.current().nextBytes(bytes);
    }

    public static byte[] secureRandomBytes(int len) {
        if (len <= 0) {
            len = 1;
        }
        byte[] buff = new byte[len];
        MathUtils.getSecureRandom().nextBytes(buff);
        return buff;
    }

    public static int randomInt(int lowerThan) {
        return ThreadLocalRandom.current().nextInt(lowerThan);
    }

    public static int secureRandomInt(int lowerThan) {
        return MathUtils.getSecureRandom().nextInt(lowerThan);
    }
}

