/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.ddl.CreateSynonymData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObjectBase;
import org.gridgain.internal.h2.table.Table;

public class TableSynonym
extends SchemaObjectBase {
    private CreateSynonymData data;
    private Table synonymFor;

    public TableSynonym(CreateSynonymData data) {
        super(data.schema, data.id, data.synonymName, 11);
        this.data = data;
    }

    public Table getSynonymFor() {
        return this.synonymFor;
    }

    public void updateData(CreateSynonymData data) {
        this.data = data;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.synonymFor.getCreateSQLForCopy(table, quotedName);
    }

    @Override
    public void rename(String newName) {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.synonymFor.removeSynonym(this);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public String getCreateSQL() {
        StringBuilder builder = new StringBuilder("CREATE SYNONYM ");
        this.getSQL(builder, true).append(" FOR ");
        Parser.quoteIdentifier(builder, this.data.synonymForSchema.getName(), true).append('.');
        Parser.quoteIdentifier(builder, this.data.synonymFor, true);
        return builder.toString();
    }

    @Override
    public String getDropSQL() {
        StringBuilder builder = new StringBuilder("DROP SYNONYM ");
        return this.getSQL(builder, true).toString();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    public String getSynonymForName() {
        return this.data.synonymFor;
    }

    public Schema getSynonymForSchema() {
        return this.data.synonymForSchema;
    }

    public boolean isInvalid() {
        return this.synonymFor.isValid();
    }

    public void updateSynonymFor() {
        if (this.synonymFor != null) {
            this.synonymFor.removeSynonym(this);
        }
        this.synonymFor = this.data.synonymForSchema.getTableOrView(this.data.session, this.data.synonymFor);
        this.synonymFor.addSynonym(this);
    }
}

