/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.tx;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.mvstore.type.DataType;
import org.gridgain.internal.h2.value.VersionedValue;

public class Transaction {
    public static final int STATUS_CLOSED = 0;
    public static final int STATUS_OPEN = 1;
    public static final int STATUS_PREPARED = 2;
    public static final int STATUS_COMMITTED = 3;
    private static final int STATUS_ROLLING_BACK = 4;
    private static final int STATUS_ROLLED_BACK = 5;
    private static final String[] STATUS_NAMES = new String[]{"CLOSED", "OPEN", "PREPARED", "COMMITTED", "ROLLING_BACK", "ROLLED_BACK"};
    static final int LOG_ID_BITS = 40;
    private static final int LOG_ID_BITS1 = 41;
    private static final long LOG_ID_LIMIT = 0x10000000000L;
    private static final long LOG_ID_MASK = 0x1FFFFFFFFFFL;
    private static final int STATUS_BITS = 4;
    private static final int STATUS_MASK = 15;
    final TransactionStore store;
    final TransactionStore.RollbackListener listener;
    final int transactionId;
    final long sequenceNum;
    private final AtomicLong statusAndLogId;
    private MVStore.TxCounter txCounter;
    private String name;
    boolean wasStored;
    final int timeoutMillis;
    private final int ownerId;
    private volatile Transaction blockingTransaction;
    private MVMap<?, VersionedValue> blockingMap;
    private Object blockingKey;
    private volatile boolean notificationRequested;

    Transaction(TransactionStore store, int transactionId, long sequenceNum, int status, String name, long logId, int timeoutMillis, int ownerId, TransactionStore.RollbackListener listener) {
        this.store = store;
        this.transactionId = transactionId;
        this.sequenceNum = sequenceNum;
        this.statusAndLogId = new AtomicLong(Transaction.composeState(status, logId, false));
        this.name = name;
        this.timeoutMillis = timeoutMillis;
        this.ownerId = ownerId;
        this.listener = listener;
    }

    public int getId() {
        return this.transactionId;
    }

    public long getSequenceNum() {
        return this.sequenceNum;
    }

    public int getStatus() {
        return Transaction.getStatus(this.statusAndLogId.get());
    }

    private long setStatus(int status) {
        long logId;
        long newState;
        long currentState;
        do {
            boolean valid;
            currentState = this.statusAndLogId.get();
            logId = Transaction.getLogId(currentState);
            int currentStatus = Transaction.getStatus(currentState);
            switch (status) {
                case 4: {
                    valid = currentStatus == 1;
                    break;
                }
                case 2: {
                    valid = currentStatus == 1;
                    break;
                }
                case 3: {
                    valid = currentStatus == 1 || currentStatus == 2 || currentStatus == 3;
                    break;
                }
                case 5: {
                    valid = currentStatus == 1 || currentStatus == 2;
                    break;
                }
                case 0: {
                    valid = currentStatus == 3 || currentStatus == 5;
                    break;
                }
                default: {
                    valid = false;
                }
            }
            if (valid) continue;
            throw DataUtils.newIllegalStateException(103, "Transaction was illegally transitioned from {0} to {1}", STATUS_NAMES[currentStatus], STATUS_NAMES[status]);
        } while (!this.statusAndLogId.compareAndSet(currentState, newState = Transaction.composeState(status, logId, Transaction.hasRollback(currentState))));
        return currentState;
    }

    public boolean hasChanges() {
        return Transaction.hasChanges(this.statusAndLogId.get());
    }

    public void setName(String name) {
        this.checkNotClosed();
        this.name = name;
        this.store.storeTransaction(this);
    }

    public String getName() {
        return this.name;
    }

    public int getBlockerId() {
        Transaction blocker = this.blockingTransaction;
        return blocker == null ? 0 : blocker.ownerId;
    }

    public long setSavepoint() {
        return this.getLogId();
    }

    public void markStatementStart() {
        this.markStatementEnd();
        this.txCounter = this.store.store.registerVersionUsage();
    }

    public void markStatementEnd() {
        MVStore.TxCounter counter = this.txCounter;
        if (counter != null) {
            this.txCounter = null;
            this.store.store.deregisterVersionUsage(counter);
        }
    }

    long log(int mapId, Object key, VersionedValue oldValue) {
        long currentState = this.statusAndLogId.getAndIncrement();
        long logId = Transaction.getLogId(currentState);
        if (logId >= 0x10000000000L) {
            throw DataUtils.newIllegalStateException(104, "Transaction {0} has too many changes", this.transactionId);
        }
        int currentStatus = Transaction.getStatus(currentState);
        this.checkOpen(currentStatus);
        long undoKey = this.store.addUndoLogRecord(this.transactionId, logId, new Object[]{mapId, key, oldValue});
        return undoKey;
    }

    void logUndo() {
        long currentState = this.statusAndLogId.decrementAndGet();
        long logId = Transaction.getLogId(currentState);
        if (logId >= 0x10000000000L) {
            throw DataUtils.newIllegalStateException(100, "Transaction {0} has internal error", this.transactionId);
        }
        int currentStatus = Transaction.getStatus(currentState);
        this.checkOpen(currentStatus);
        this.store.removeUndoLogRecord(this.transactionId);
    }

    public <K, V> TransactionMap<K, V> openMap(String name) {
        return this.openMap(name, null, null);
    }

    public <K, V> TransactionMap<K, V> openMap(String name, DataType keyType, DataType valueType) {
        MVMap map = this.store.openMap(name, keyType, valueType);
        return this.openMap(map);
    }

    public <K, V> TransactionMap<K, V> openMap(MVMap<K, VersionedValue> map) {
        this.checkNotClosed();
        return new TransactionMap(this, map);
    }

    public void prepare() {
        this.setStatus(2);
        this.store.storeTransaction(this);
    }

    public void commit() {
        assert (this.store.openTransactions.get().get(this.transactionId));
        Throwable ex = null;
        boolean hasChanges = false;
        try {
            long state = this.setStatus(3);
            hasChanges = Transaction.hasChanges(state);
            int previousStatus = Transaction.getStatus(state);
            if (hasChanges) {
                this.store.commit(this, previousStatus == 3);
            }
        }
        catch (Throwable e) {
            ex = e;
            throw e;
        }
        finally {
            try {
                this.store.endTransaction(this, hasChanges);
            }
            catch (Throwable e) {
                if (ex == null) {
                    throw e;
                }
                ex.addSuppressed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackToSavepoint(long savepointId) {
        boolean success;
        long lastState = this.setStatus(4);
        long logId = Transaction.getLogId(lastState);
        try {
            this.store.rollbackTo(this, logId, savepointId);
        }
        finally {
            if (this.notificationRequested) {
                this.notifyAllWaitingTransactions();
            }
            long expectedState = Transaction.composeState(4, logId, Transaction.hasRollback(lastState));
            long newState = Transaction.composeState(1, savepointId, true);
            while (!(success = this.statusAndLogId.compareAndSet(expectedState, newState)) && this.statusAndLogId.get() == expectedState) {
            }
        }
        if (!success) {
            throw DataUtils.newIllegalStateException(103, "Transaction {0} concurrently modified while rollback to savepoint was in progress", this.transactionId);
        }
    }

    public void rollback() {
        Throwable ex = null;
        try {
            long lastState = this.setStatus(5);
            long logId = Transaction.getLogId(lastState);
            if (logId > 0L) {
                this.store.rollbackTo(this, logId, 0L);
            }
        }
        catch (Throwable e) {
            ex = e;
            throw e;
        }
        finally {
            try {
                this.store.endTransaction(this, true);
            }
            catch (Throwable e) {
                if (ex == null) {
                    throw e;
                }
                ex.addSuppressed(e);
            }
        }
    }

    public Iterator<TransactionStore.Change> getChanges(long savepointId) {
        return this.store.getChanges(this, this.getLogId(), savepointId);
    }

    private long getLogId() {
        return Transaction.getLogId(this.statusAndLogId.get());
    }

    private void checkOpen(int status) {
        if (status != 1) {
            throw DataUtils.newIllegalStateException(103, "Transaction {0} has status {1}, not OPEN", this.transactionId, STATUS_NAMES[status]);
        }
    }

    private void checkNotClosed() {
        if (this.getStatus() == 0) {
            throw DataUtils.newIllegalStateException(4, "Transaction {0} is closed", this.transactionId);
        }
    }

    void closeIt() {
        long lastState = this.setStatus(0);
        this.store.store.deregisterVersionUsage(this.txCounter);
        if ((Transaction.hasChanges(lastState) || Transaction.hasRollback(lastState)) && this.notificationRequested) {
            this.notifyAllWaitingTransactions();
        }
    }

    private synchronized void notifyAllWaitingTransactions() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(Transaction toWaitFor, MVMap<?, VersionedValue> map, Object key) {
        this.blockingTransaction = toWaitFor;
        this.blockingMap = map;
        this.blockingKey = key;
        if (this.isDeadlocked(toWaitFor)) {
            Transaction nextTx;
            StringBuilder details = new StringBuilder(String.format("Transaction %d has been chosen as a deadlock victim. Details:%n", this.transactionId));
            Transaction tx = toWaitFor;
            while ((nextTx = tx.blockingTransaction) != null) {
                details.append(String.format("Transaction %d attempts to update map <%s> entry with key <%s> modified by transaction %s%n", tx.transactionId, tx.blockingMap.getName(), tx.blockingKey, tx.blockingTransaction));
                if (nextTx == this) {
                    details.append(String.format("Transaction %d attempts to update map <%s> entry with key <%s> modified by transaction %s%n", this.transactionId, this.blockingMap.getName(), this.blockingKey, toWaitFor));
                    if (this.isDeadlocked(toWaitFor)) {
                        throw DataUtils.newIllegalStateException(105, details.toString(), new Object[0]);
                    }
                }
                tx = nextTx;
            }
        }
        try {
            boolean bl = toWaitFor.waitForThisToEnd(this.timeoutMillis);
            return bl;
        }
        finally {
            this.blockingMap = null;
            this.blockingKey = null;
            this.blockingTransaction = null;
        }
    }

    private boolean isDeadlocked(Transaction toWaitFor) {
        Transaction nextTx;
        Transaction tx = toWaitFor;
        while ((nextTx = tx.blockingTransaction) != null && tx.getStatus() == 1) {
            if (nextTx == this) {
                return true;
            }
            tx = nextTx;
        }
        return false;
    }

    private synchronized boolean waitForThisToEnd(int millis) {
        long state;
        int status;
        long until = System.currentTimeMillis() + (long)millis;
        this.notificationRequested = true;
        while ((status = Transaction.getStatus(state = this.statusAndLogId.get())) != 0 && status != 5 && !Transaction.hasRollback(state)) {
            long dur = until - System.currentTimeMillis();
            if (dur <= 0L) {
                return false;
            }
            try {
                this.wait(dur);
            }
            catch (InterruptedException ex) {
                return false;
            }
        }
        return true;
    }

    public <K, V> void removeMap(TransactionMap<K, V> map) {
        this.store.removeMap(map);
    }

    public String toString() {
        return this.transactionId + "(" + this.sequenceNum + ") " + this.stateToString();
    }

    private String stateToString() {
        return Transaction.stateToString(this.statusAndLogId.get());
    }

    private static String stateToString(long state) {
        return STATUS_NAMES[Transaction.getStatus(state)] + (Transaction.hasRollback(state) ? "<" : "") + " " + Transaction.getLogId(state);
    }

    private static int getStatus(long state) {
        return (int)(state >>> 41) & 0xF;
    }

    private static long getLogId(long state) {
        return state & 0x1FFFFFFFFFFL;
    }

    private static boolean hasRollback(long state) {
        return (state & 0x200000000000L) != 0L;
    }

    private static boolean hasChanges(long state) {
        return Transaction.getLogId(state) != 0L;
    }

    private static long composeState(int status, long logId, boolean hasRollback) {
        assert (logId < 0x10000000000L) : logId;
        assert ((status & 0xFFFFFFF0) == 0) : status;
        if (hasRollback) {
            status |= 0x10;
        }
        return (long)status << 41 | logId;
    }
}

