/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.db.MVIndex;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public final class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        this.mvTable = table;
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(columns);
        }
        this.keyColumns = columns.length + 1;
        String mapName = "index." + this.getId();
        assert (db.isStarting() || !db.getStore().getMvStore().getMetaMap().containsKey("name." + mapName));
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < columns.length; ++i) {
            sortTypes[i] = columns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(db, sortTypes);
        ValueDataType valueType = new ValueDataType();
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(mapName, keyType, valueType);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        t.commit();
        if (!keyType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + keyType + " but got " + this.dataMap.getKeyType() + " for index " + indexName);
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        MVMap<ValueArray, Value> map = this.openMap(bufferName);
        for (Row row : rows) {
            ValueArray key = this.convertToKey(row, null);
            map.append(key, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> bufferNames) {
        CompareMode compareMode = this.database.getCompareMode();
        int buffersCount = bufferNames.size();
        PriorityQueue<Source> queue = new PriorityQueue<Source>(buffersCount, new Source.Comparator(this.database.getMode(), compareMode));
        for (String bufferName : bufferNames) {
            Iterator<Object> iter = this.openMap(bufferName).keyIterator(null);
            if (!iter.hasNext()) continue;
            queue.offer(new Source(iter));
        }
        try {
            while (!queue.isEmpty()) {
                Source s = (Source)queue.poll();
                ValueArray rowData = s.next();
                SearchRow row = this.convertToSearchRow(rowData);
                if (this.indexType.isUnique() && !this.mayHaveNullDuplicates(row)) {
                    this.checkUnique(this.dataMap, rowData, Long.MIN_VALUE);
                }
                this.dataMap.putCommitted(rowData, ValueNull.INSTANCE);
                if (!s.hasNext()) continue;
                queue.offer(s);
            }
        }
        finally {
            MVStore mvStore = this.database.getStore().getMvStore();
            for (String tempMapName : bufferNames) {
                mvStore.removeMap(tempMapName);
            }
        }
    }

    private MVMap<ValueArray, Value> openMap(String mapName) {
        int[] sortTypes = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            sortTypes[i] = this.indexColumns[i].sortType;
        }
        sortTypes[this.keyColumns - 1] = 0;
        ValueDataType keyType = new ValueDataType(this.database, sortTypes);
        ValueDataType valueType = new ValueDataType();
        MVMap.BasicBuilder builder = ((MVMap.Builder)new MVMap.Builder().singleWriter().keyType(keyType)).valueType(valueType);
        Object map = this.database.getStore().getMvStore().openMap(mapName, builder);
        if (!keyType.equals(((MVMap)map).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type, expected " + keyType + " but got " + ((MVMap)map).getKeyType() + " for map " + mapName);
        }
        return map;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        boolean checkRequired;
        TransactionMap<Value, Value> map = this.getMap(session);
        ValueArray array = this.convertToKey(row, null);
        boolean bl = checkRequired = this.indexType.isUnique() && !this.mayHaveNullDuplicates(row);
        if (checkRequired) {
            this.checkUnique(map, array, Long.MIN_VALUE);
        }
        try {
            map.put(array, ValueNull.INSTANCE);
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (checkRequired) {
            this.checkUnique(map, array, row.getKey());
        }
    }

    private void checkUnique(TransactionMap<Value, Value> map, ValueArray row, long newKey) {
        Iterator<Value> it = map.keyIterator(MVSecondaryIndex.convertToKey(row, ValueLong.MIN), MVSecondaryIndex.convertToKey(row, ValueLong.MAX), true);
        while (it.hasNext()) {
            ValueArray rowData = (ValueArray)it.next();
            Value[] array = rowData.getList();
            Value rowKey = array[array.length - 1];
            long rowId = rowKey.getLong();
            if (newKey == rowId) continue;
            if (map.get(rowData) != null) {
                throw this.getDuplicateKeyException(rowKey.toString());
            }
            throw DbException.get(90131, this.table.getName());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray array = this.convertToKey(row, null);
        TransactionMap<Value, Value> map = this.getMap(session);
        try {
            Value old = map.remove(array);
            if (old == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, false).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void update(Session session, Row oldRow, Row newRow) {
        if (!this.rowsAreEqual(oldRow, newRow)) {
            super.update(session, oldRow, newRow);
        }
    }

    private boolean rowsAreEqual(SearchRow rowOne, SearchRow rowTwo) {
        if (rowOne == rowTwo) {
            return true;
        }
        for (int index : this.columnIds) {
            Value v1 = rowOne.getValue(index);
            Value v2 = rowTwo.getValue(index);
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        return rowOne.getKey() == rowTwo.getKey();
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, false, last);
    }

    private Cursor find(Session session, SearchRow first, boolean bigger, SearchRow last) {
        ValueArray min = this.convertToKey(first, bigger ? ValueLong.MAX : ValueLong.MIN);
        ValueArray max = this.convertToKey(last, ValueLong.MAX);
        TransactionMap<Value, Value> map = this.getMap(session);
        return new MVStoreCursor(session, map.keyIterator(min, max, false));
    }

    private static ValueArray convertToKey(ValueArray r, ValueLong key) {
        Value[] values = (Value[])r.getList().clone();
        values[values.length - 1] = key;
        return ValueArray.get(values);
    }

    private ValueArray convertToKey(SearchRow r, ValueLong key) {
        if (r == null) {
            return null;
        }
        Value[] array = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            int idx = c.getColumnId();
            Value v = r.getValue(idx);
            if (v == null) continue;
            array[i] = v.convertTo(c.getType(), this.database.getMode(), null);
        }
        array[this.keyColumns - 1] = key != null ? key : ValueLong.get(r.getKey());
        return ValueArray.get(array);
    }

    SearchRow convertToSearchRow(ValueArray key) {
        Value[] array = key.getList();
        Row searchRow = this.mvTable.getTemplateRow();
        searchRow.setKey(array[array.length - 1].getLong());
        Column[] cols = this.getColumns();
        for (int i = 0; i < array.length - 1; ++i) {
            Column c = cols[i];
            int idx = c.getColumnId();
            Value v = array[i];
            searchRow.setValue(idx, v);
        }
        return searchRow;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, false, allColumnsSet);
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        Value key;
        TransactionMap<Value, Value> map = this.getMap(session);
        Value value = key = first ? map.firstKey() : map.lastKey();
        while (true) {
            if (key == null) {
                return new MVStoreCursor(session, Collections.emptyIterator());
            }
            if (((ValueArray)key).getList()[0] != ValueNull.INSTANCE) break;
            key = first ? map.higherKey(key) : map.lowerKey(key);
        }
        MVStoreCursor cursor = new MVStoreCursor(session, Collections.singletonList(key).iterator());
        cursor.next();
        return cursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<Value, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        return this.find(session, higherThan, true, last);
    }

    @Override
    public void checkRename() {
    }

    private TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    final class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private ValueArray current;
        private Row row;

        MVStoreCursor(Session session, Iterator<Value> it) {
            this.session = session;
            this.it = it;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                Value[] values = this.current.getList();
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, values[values.length - 1].getLong());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.current == null ? null : MVSecondaryIndex.this.convertToSearchRow(this.current);
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? (ValueArray)this.it.next() : null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }

    private static final class Source {
        private final Iterator<ValueArray> iterator;
        ValueArray currentRowData;

        public Source(Iterator<ValueArray> iterator) {
            this.iterator = iterator;
            this.currentRowData = iterator.next();
        }

        public boolean hasNext() {
            boolean result = this.iterator.hasNext();
            if (result) {
                this.currentRowData = this.iterator.next();
            }
            return result;
        }

        public ValueArray next() {
            return this.currentRowData;
        }

        public static final class Comparator
        implements java.util.Comparator<Source> {
            private final Mode databaseMode;
            private final CompareMode compareMode;

            public Comparator(Mode databaseMode, CompareMode compareMode) {
                this.databaseMode = databaseMode;
                this.compareMode = compareMode;
            }

            @Override
            public int compare(Source one, Source two) {
                return one.currentRowData.compareTo(two.currentRowData, this.databaseMode, this.compareMode);
            }
        }
    }
}

