/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.gridgain.internal.h2.command.CommandInterface;
import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.engine.SessionRemote;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.jdbc.JdbcArray;
import org.gridgain.internal.h2.jdbc.JdbcBlob;
import org.gridgain.internal.h2.jdbc.JdbcCallableStatement;
import org.gridgain.internal.h2.jdbc.JdbcClob;
import org.gridgain.internal.h2.jdbc.JdbcConnectionBackwardsCompat;
import org.gridgain.internal.h2.jdbc.JdbcDatabaseMetaData;
import org.gridgain.internal.h2.jdbc.JdbcLob;
import org.gridgain.internal.h2.jdbc.JdbcPreparedStatement;
import org.gridgain.internal.h2.jdbc.JdbcResultSet;
import org.gridgain.internal.h2.jdbc.JdbcSQLXML;
import org.gridgain.internal.h2.jdbc.JdbcSavepoint;
import org.gridgain.internal.h2.jdbc.JdbcStatement;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.TraceObject;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.util.CloseWatcher;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBytes;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueResultSet;
import org.gridgain.internal.h2.value.ValueString;

public class JdbcConnection
extends TraceObject
implements Connection,
JdbcConnectionBackwardsCompat {
    private static final String NUM_SERVERS = "numServers";
    private static final String PREFIX_SERVER = "server";
    private static boolean keepOpenStackTrace;
    private final String url;
    private final String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setLockMode;
    private CommandInterface getLockMode;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private int savepointId;
    private String catalog;
    private Statement executingStatement;
    private final CloseWatcher watcher;
    private int queryTimeoutCache = -1;
    private Map<String, String> clientInfo;
    private volatile Settings settings;
    private final boolean scopeGeneratedKeys;

    public JdbcConnection(String url, Properties info) throws SQLException {
        this(new ConnectionInfo(url, info), true);
    }

    public JdbcConnection(ConnectionInfo ci, boolean useBaseDir) throws SQLException {
        try {
            String baseDir;
            if (useBaseDir && (baseDir = SysProperties.getBaseDir()) != null) {
                ci.setBaseDir(baseDir);
            }
            this.session = new SessionRemote(ci).connectEmbeddedOrServer(false);
            this.trace = this.session.getTrace();
            int id = JdbcConnection.getNextId(1);
            this.setTrace(this.trace, 1, id);
            this.user = ci.getUserName();
            if (this.isInfoEnabled()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + JdbcConnection.quote(ci.getOriginalURL()) + ", " + JdbcConnection.quote(this.user) + ", \"\");");
            }
            this.url = ci.getURL();
            this.scopeGeneratedKeys = ci.getProperty("SCOPE_GENERATED_KEYS", false);
            this.closeOld();
            this.watcher = CloseWatcher.register(this, this.session, keepOpenStackTrace);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public JdbcConnection(JdbcConnection clone) {
        this.session = clone.session;
        this.trace = this.session.getTrace();
        int id = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, id);
        this.user = clone.user;
        this.url = clone.url;
        this.catalog = clone.catalog;
        this.commit = clone.commit;
        this.getGeneratedKeys = clone.getGeneratedKeys;
        this.getLockMode = clone.getLockMode;
        this.getQueryTimeout = clone.getQueryTimeout;
        this.getReadOnly = clone.getReadOnly;
        this.rollback = clone.rollback;
        this.scopeGeneratedKeys = clone.scopeGeneratedKeys;
        this.watcher = null;
        if (clone.clientInfo != null) {
            this.clientInfo = new HashMap<String, String>(clone.clientInfo);
        }
    }

    public JdbcConnection(SessionInterface session, String user, String url) {
        this.session = session;
        this.trace = session.getTrace();
        int id = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, id);
        this.user = user;
        this.url = url;
        this.scopeGeneratedKeys = false;
        this.watcher = null;
    }

    private void closeOld() {
        CloseWatcher w;
        while ((w = CloseWatcher.pollUnclosed()) != null) {
            try {
                w.getCloseable().close();
            }
            catch (Exception e) {
                this.trace.error(e, "closing session");
            }
            keepOpenStackTrace = true;
            String s = w.getOpenStackTrace();
            DbException ex = DbException.get(90018);
            this.trace.error(ex, s);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, id, 1003, 1007, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement(" + resultSetType + ", " + resultSetConcurrency + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            this.checkClosed();
            return new JdbcStatement(this, id, resultSetType, resultSetConcurrency, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, id, "createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            JdbcConnection.checkHoldability(resultSetHoldability);
            this.checkClosed();
            return new JdbcStatement(this, id, resultSetType, resultSetConcurrency, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ")");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, 1003, 1007, false, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String sql) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ")");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, 1003, 1007, true, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, id, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            if (this.session == null) {
                return;
            }
            CloseWatcher.unregister(this.watcher);
            this.session.cancel();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                block19: {
                    if (this.executingStatement != null) {
                        try {
                            this.executingStatement.cancel();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    try {
                        if (this.session.isClosed()) break block19;
                        try {
                            if (this.session.hasPendingTransaction()) {
                                block20: {
                                    if (!this.session.isReconnectNeeded(true)) {
                                        try {
                                            this.rollbackInternal();
                                        }
                                        catch (DbException e) {
                                            if (e.getErrorCode() == 90067) break block20;
                                            throw e;
                                        }
                                    }
                                }
                                this.session.afterWriting();
                            }
                            this.closePreparedCommands();
                        }
                        finally {
                            this.session.close();
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    private void closePreparedCommands() {
        this.commit = JdbcConnection.closeAndSetNull(this.commit);
        this.rollback = JdbcConnection.closeAndSetNull(this.rollback);
        this.getReadOnly = JdbcConnection.closeAndSetNull(this.getReadOnly);
        this.getGeneratedKeys = JdbcConnection.closeAndSetNull(this.getGeneratedKeys);
        this.getLockMode = JdbcConnection.closeAndSetNull(this.getLockMode);
        this.setLockMode = JdbcConnection.closeAndSetNull(this.setLockMode);
        this.getQueryTimeout = JdbcConnection.closeAndSetNull(this.getQueryTimeout);
        this.setQueryTimeout = JdbcConnection.closeAndSetNull(this.setQueryTimeout);
    }

    private static CommandInterface closeAndSetNull(CommandInterface command) {
        if (command != null) {
            command.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + autoCommit + ");");
            }
            this.checkClosed();
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                if (autoCommit && !this.session.getAutoCommit()) {
                    this.commit();
                }
                this.session.setAutoCommit(autoCommit);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.session.getAutoCommit();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosedForWrite();
            try {
                this.commit = this.prepareCommand("COMMIT", this.commit);
                this.commit.executeUpdate(false);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosedForWrite();
            try {
                this.rollbackInternal();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", sql);
            this.checkClosed();
            return JdbcConnection.translateSQL(sql);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + readOnly + ");");
            }
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface result = this.getReadOnly.executeQuery(0, false);
            result.next();
            return result.currentRow()[0].getBoolean();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", catalog);
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface cat = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface result = cat.executeQuery(0, false);
                result.next();
                this.catalog = result.currentRow()[0].getString();
                cat.close();
            }
            return this.catalog;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, resultSetType, resultSetConcurrency, false, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            int lockMode;
            this.debugCodeCall("setTransactionIsolation", level);
            this.checkClosed();
            switch (level) {
                case 1: {
                    lockMode = 0;
                    break;
                }
                case 2: {
                    lockMode = 3;
                    break;
                }
                case 4: 
                case 8: {
                    lockMode = 1;
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("level", level);
                }
            }
            this.commit();
            this.setLockMode = this.prepareCommand("SET LOCK_MODE ?", this.setLockMode);
            this.setLockMode.getParameters().get(0).setValue(ValueInt.get(lockMode), false);
            this.setLockMode.executeUpdate(false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", seconds);
            this.checkClosed();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            this.setQueryTimeout.getParameters().get(0).setValue(ValueInt.get(seconds * 1000), false);
            this.setQueryTimeout.executeUpdate(false);
            this.queryTimeoutCache = seconds;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    int getQueryTimeout() throws SQLException {
        try {
            if (this.queryTimeoutCache == -1) {
                this.checkClosed();
                this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
                this.getQueryTimeout.getParameters().get(0).setValue(ValueString.get("QUERY_TIMEOUT"), false);
                ResultInterface result = this.getQueryTimeout.executeQuery(0, false);
                result.next();
                int queryTimeout = result.currentRow()[0].getInt();
                result.close();
                if (queryTimeout != 0) {
                    queryTimeout = (queryTimeout + 999) / 1000;
                }
                this.queryTimeoutCache = queryTimeout;
            }
            return this.queryTimeoutCache;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int transactionIsolationLevel;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.getLockMode = this.prepareCommand("CALL LOCK_MODE()", this.getLockMode);
            ResultInterface result = this.getLockMode.executeQuery(0, false);
            result.next();
            int lockMode = result.currentRow()[0].getInt();
            result.close();
            switch (lockMode) {
                case 0: {
                    transactionIsolationLevel = 1;
                    break;
                }
                case 3: {
                    transactionIsolationLevel = 2;
                    break;
                }
                case 1: 
                case 2: {
                    transactionIsolationLevel = 8;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("lockMode:" + lockMode);
                }
            }
            return transactionIsolationLevel;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", holdability);
            this.checkClosed();
            JdbcConnection.checkHoldability(holdability);
            this.holdability = holdability;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTypeMap(" + JdbcConnection.quoteMap(map) + ");");
            }
            JdbcConnection.checkMap(map);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + JdbcConnection.quote(sql) + ")");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcCallableStatement(this, sql, id, 1003, 1007);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + JdbcConnection.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcCallableStatement(this, sql, id, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, id, "prepareCall(" + JdbcConnection.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            JdbcConnection.checkHoldability(resultSetHoldability);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcCallableStatement(this, sql, id, resultSetType, resultSetConcurrency);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, id, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            set.executeUpdate(false);
            JdbcSavepoint savepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, id);
            ++this.savepointId;
            return savepoint;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, id, "setSavepoint(" + JdbcConnection.quote(name) + ")");
            }
            this.checkClosed();
            CommandInterface set = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(name, 0), Integer.MAX_VALUE);
            set.executeUpdate(false);
            return new JdbcSavepoint(this, 0, name, this.trace, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint sp = JdbcConnection.convertSavepoint(savepoint);
            if (this.isDebugEnabled()) {
                this.debugCode("rollback(" + sp.getTraceObjectName() + ");");
            }
            this.checkClosedForWrite();
            try {
                sp.rollback();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            JdbcConnection.convertSavepoint(savepoint).release();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private static JdbcSavepoint convertSavepoint(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, String.valueOf(savepoint));
        }
        return (JdbcSavepoint)savepoint;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
            }
            JdbcConnection.checkTypeConcurrency(resultSetType, resultSetConcurrency);
            JdbcConnection.checkHoldability(resultSetHoldability);
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, resultSetType, resultSetConcurrency, false, false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ", " + autoGeneratedKeys + ");");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, 1003, 1007, false, autoGeneratedKeys == 1);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ", " + JdbcConnection.quoteIntArray(columnIndexes) + ");");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, 1003, 1007, false, columnIndexes);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, id, "prepareStatement(" + JdbcConnection.quote(sql) + ", " + JdbcConnection.quoteArray(columnNames) + ");");
            }
            this.checkClosed();
            sql = JdbcConnection.translateSQL(sql);
            return new JdbcPreparedStatement(this, sql, id, 1003, 1007, false, columnNames);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    CommandInterface prepareCommand(String sql, int fetchSize) {
        return this.session.prepareCommand(sql, fetchSize);
    }

    private CommandInterface prepareCommand(String sql, CommandInterface old) {
        return old == null ? this.session.prepareCommand(sql, Integer.MAX_VALUE) : old;
    }

    private static int translateGetEnd(String sql, int i, char c) {
        int len = sql.length();
        switch (c) {
            case '$': {
                if (i < len - 1 && sql.charAt(i + 1) == '$' && (i == 0 || sql.charAt(i - 1) <= ' ')) {
                    int j = sql.indexOf("$$", i + 2);
                    if (j < 0) {
                        throw DbException.getSyntaxError(sql, i);
                    }
                    return j + 1;
                }
                return i;
            }
            case '\'': {
                int j = sql.indexOf(39, i + 1);
                if (j < 0) {
                    throw DbException.getSyntaxError(sql, i);
                }
                return j;
            }
            case '\"': {
                int j = sql.indexOf(34, i + 1);
                if (j < 0) {
                    throw DbException.getSyntaxError(sql, i);
                }
                return j;
            }
            case '/': {
                JdbcConnection.checkRunOver(i + 1, len, sql);
                if (sql.charAt(i + 1) == '*') {
                    int j = sql.indexOf("*/", i + 2);
                    if (j < 0) {
                        throw DbException.getSyntaxError(sql, i);
                    }
                    i = j + 1;
                } else if (sql.charAt(i + 1) == '/') {
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                }
                return i;
            }
            case '-': {
                JdbcConnection.checkRunOver(i + 1, len, sql);
                if (sql.charAt(i + 1) == '-') {
                    i += 2;
                    while (i < len && (c = sql.charAt(i)) != '\r' && c != '\n') {
                        ++i;
                    }
                }
                return i;
            }
        }
        throw DbException.throwInternalError("c=" + c);
    }

    private static String translateSQL(String sql) {
        return JdbcConnection.translateSQL(sql, true);
    }

    static String translateSQL(String sql, boolean escapeProcessing) {
        if (sql == null) {
            throw DbException.getInvalidValueException("SQL", null);
        }
        if (!escapeProcessing) {
            return sql;
        }
        if (sql.indexOf(123) < 0) {
            return sql;
        }
        int len = sql.length();
        char[] chars = null;
        int level = 0;
        block9: for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = JdbcConnection.translateGetEnd(sql, i, c);
                    continue block9;
                }
                case '{': {
                    ++level;
                    if (chars == null) {
                        chars = sql.toCharArray();
                    }
                    chars[i] = 32;
                    while (Character.isSpaceChar(chars[i])) {
                        JdbcConnection.checkRunOver(++i, len, sql);
                    }
                    int start = i;
                    if (chars[i] >= '0' && chars[i] <= '9') {
                        chars[i - 1] = 123;
                        while (true) {
                            JdbcConnection.checkRunOver(i, len, sql);
                            c = chars[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = JdbcConnection.translateGetEnd(sql, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --level;
                        continue block9;
                    }
                    if (chars[i] == '?') {
                        JdbcConnection.checkRunOver(++i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            JdbcConnection.checkRunOver(++i, len, sql);
                        }
                        if (sql.charAt(i) != '=') {
                            throw DbException.getSyntaxError(sql, i, "=");
                        }
                        JdbcConnection.checkRunOver(++i, len, sql);
                        while (Character.isSpaceChar(chars[i])) {
                            JdbcConnection.checkRunOver(++i, len, sql);
                        }
                    }
                    while (!Character.isSpaceChar(chars[i])) {
                        JdbcConnection.checkRunOver(++i, len, sql);
                    }
                    int remove = 0;
                    if (JdbcConnection.found(sql, start, "fn")) {
                        remove = 2;
                    } else {
                        if (JdbcConnection.found(sql, start, "escape") || JdbcConnection.found(sql, start, "call")) continue block9;
                        if (JdbcConnection.found(sql, start, "oj")) {
                            remove = 2;
                        } else {
                            if (JdbcConnection.found(sql, start, "ts") || JdbcConnection.found(sql, start, "t") || JdbcConnection.found(sql, start, "d")) continue block9;
                            if (JdbcConnection.found(sql, start, "params")) {
                                remove = "params".length();
                            }
                        }
                    }
                    i = start;
                    while (remove > 0) {
                        chars[i] = 32;
                        ++i;
                        --remove;
                    }
                    continue block9;
                }
                case '}': {
                    if (--level < 0) {
                        throw DbException.getSyntaxError(sql, i);
                    }
                    chars[i] = 32;
                    continue block9;
                }
                case '$': {
                    i = JdbcConnection.translateGetEnd(sql, i, c);
                    continue block9;
                }
            }
        }
        if (level != 0) {
            throw DbException.getSyntaxError(sql, sql.length() - 1);
        }
        if (chars != null) {
            sql = new String(chars);
        }
        return sql;
    }

    private static void checkRunOver(int i, int len, String sql) {
        if (i >= len) {
            throw DbException.getSyntaxError(sql, i);
        }
    }

    private static boolean found(String sql, int start, String other) {
        return sql.regionMatches(true, start, other, 0, other.length());
    }

    private static void checkTypeConcurrency(int resultSetType, int resultSetConcurrency) {
        switch (resultSetType) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetType", resultSetType);
            }
        }
        switch (resultSetConcurrency) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetConcurrency", resultSetConcurrency);
            }
        }
    }

    private static void checkHoldability(int resultSetHoldability) {
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw DbException.getInvalidValueException("resultSetHoldability", resultSetHoldability);
        }
    }

    protected void checkClosed() {
        this.checkClosed(false);
    }

    private void checkClosedForWrite() {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean write) {
        if (this.session == null) {
            throw DbException.get(90007);
        }
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
        if (this.session.isReconnectNeeded(write)) {
            this.trace.debug("reconnect");
            this.closePreparedCommands();
            this.session = this.session.reconnect(write);
            this.trace = this.session.getTrace();
        }
    }

    protected void afterWriting() {
        if (this.session != null) {
            this.session.afterWriting();
        }
    }

    String getURL() {
        this.checkClosed();
        return this.url;
    }

    String getUser() {
        this.checkClosed();
        return this.user;
    }

    private void rollbackInternal() {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate(false);
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int count) {
        if (this.session != null) {
            this.session.setPowerOffCount(count);
        }
    }

    public void setExecutingStatement(Statement stat) {
        this.executingStatement = stat;
    }

    boolean scopeGeneratedKeys() {
        return this.scopeGeneratedKeys;
    }

    JdbcResultSet getGeneratedKeys(JdbcStatement stat, int id) {
        this.getGeneratedKeys = this.prepareCommand("SELECT SCOPE_IDENTITY() WHERE SCOPE_IDENTITY() IS NOT NULL", this.getGeneratedKeys);
        ResultInterface result = this.getGeneratedKeys.executeQuery(0, false);
        return new JdbcResultSet(this, stat, this.getGeneratedKeys, result, id, false, true, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(10);
            this.debugCodeAssign("Clob", 10, id, "createClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(9);
            this.debugCodeAssign("Blob", 9, id, "createClob()");
            this.checkClosedForWrite();
            return new JdbcBlob(this, ValueBytes.EMPTY, JdbcLob.State.NEW, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(10);
            this.debugCodeAssign("NClob", 10, id, "createNClob()");
            this.checkClosedForWrite();
            return new JdbcClob(this, ValueString.EMPTY, JdbcLob.State.NEW, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            int id = JdbcConnection.getNextId(17);
            this.debugCodeAssign("SQLXML", 17, id, "createSQLXML()");
            this.checkClosedForWrite();
            return new JdbcSQLXML(this, ValueString.EMPTY, JdbcLob.State.NEW, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            int id = JdbcConnection.getNextId(16);
            this.debugCodeAssign("Array", 16, id, "createArrayOf()");
            this.checkClosed();
            Value value = DataType.convertToValue(this.session, elements, 17);
            return new JdbcArray(this, value, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.unsupported("Struct");
    }

    @Override
    public synchronized boolean isValid(int timeout) {
        try {
            this.debugCodeCall("isValid", timeout);
            if (this.session == null || this.session.isClosed()) {
                return false;
            }
            this.getTransactionIsolation();
            return true;
        }
        catch (Exception e) {
            this.logAndConvert(e);
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(" + JdbcConnection.quote(name) + ", " + JdbcConnection.quote(value) + ");");
            }
            this.checkClosed();
            if (Objects.equals(value, this.getClientInfo(name))) {
                return;
            }
            if (JdbcConnection.isInternalProperty(name)) {
                throw new SQLClientInfoException("Property name '" + name + " is used internally by H2.", Collections.emptyMap());
            }
            Pattern clientInfoNameRegEx = this.getMode().supportedClientInfoPropertiesRegEx;
            if (clientInfoNameRegEx != null && clientInfoNameRegEx.matcher(name).matches()) {
                if (this.clientInfo == null) {
                    this.clientInfo = new HashMap<String, String>();
                }
            } else {
                throw new SQLClientInfoException("Client info name '" + name + "' not supported.", Collections.emptyMap());
            }
            this.clientInfo.put(name, value);
        }
        catch (Exception e) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(e));
        }
    }

    private static boolean isInternalProperty(String name) {
        return NUM_SERVERS.equals(name) || name.startsWith(PREFIX_SERVER);
    }

    private static SQLClientInfoException convertToClientInfoException(SQLException x) {
        if (x instanceof SQLClientInfoException) {
            return (SQLClientInfoException)x;
        }
        return new SQLClientInfoException(x.getMessage(), x.getSQLState(), x.getErrorCode(), null, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClientInfo(properties);");
            }
            this.checkClosed();
            if (this.clientInfo == null) {
                this.clientInfo = new HashMap<String, String>();
            } else {
                this.clientInfo.clear();
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setClientInfo((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (Exception e) {
            throw JdbcConnection.convertToClientInfoException(this.logAndConvert(e));
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getClientInfo();");
            }
            this.checkClosed();
            ArrayList<String> serverList = this.session.getClusterServers();
            Properties p = new Properties();
            if (this.clientInfo != null) {
                for (Map.Entry<String, String> entry : this.clientInfo.entrySet()) {
                    p.setProperty(entry.getKey(), entry.getValue());
                }
            }
            p.setProperty(NUM_SERVERS, Integer.toString(serverList.size()));
            for (int i = 0; i < serverList.size(); ++i) {
                p.setProperty(PREFIX_SERVER + i, serverList.get(i));
            }
            return p;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getClientInfo", name);
            }
            this.checkClosed();
            if (name == null) {
                throw DbException.getInvalidValueException("name", null);
            }
            return this.getClientInfo().getProperty(name);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public Value createClob(Reader x, long length) {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (length <= 0L) {
            length = -1L;
        }
        Value v = this.session.getDataHandler().getLobStorage().createClob(x, length);
        this.session.addTemporaryLob(v);
        return v;
    }

    public Value createBlob(InputStream x, long length) {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        if (length <= 0L) {
            length = -1L;
        }
        Value v = this.session.getDataHandler().getLobStorage().createBlob(x, length);
        this.session.addTemporaryLob(v);
        return v;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setSchema", schema);
            }
            this.checkClosed();
            this.session.setCurrentSchemaName(schema);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSchema");
            }
            this.checkClosed();
            return this.session.getCurrentSchemaName();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }

    static void checkMap(Map<String, Class<?>> map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    Object convertToDefaultObject(Value v) {
        switch (v.getValueType()) {
            case 16: {
                int id = JdbcConnection.getNextId(10);
                return new JdbcClob(this, v, JdbcLob.State.WITH_VALUE, id);
            }
            case 15: {
                int id = JdbcConnection.getNextId(9);
                return new JdbcBlob(this, v, JdbcLob.State.WITH_VALUE, id);
            }
            case 19: {
                if (!SysProperties.serializeJavaObject) break;
                return JdbcUtils.deserialize(v.getBytesNoCopy(), this.session.getDataHandler());
            }
            case 18: {
                int id = JdbcConnection.getNextId(4);
                return new JdbcResultSet(this, null, null, ((ValueResultSet)v).getResult(), id, false, true, false);
            }
            case 2: 
            case 3: {
                if (SysProperties.OLD_RESULT_SET_GET_OBJECT) break;
                return v.getInt();
            }
        }
        return v.getObject();
    }

    CompareMode getCompareMode() {
        return this.session.getDataHandler().getCompareMode();
    }

    public void setTraceLevel(int level) {
        this.trace.setLevel(level);
    }

    Mode getMode() throws SQLException {
        return this.getSettings().mode;
    }

    public Settings getSettings() throws SQLException {
        Settings settings = this.settings;
        if (settings == null) {
            String modeName = Mode.ModeEnum.REGULAR.name();
            boolean databaseToUpper = true;
            boolean databaseToLower = false;
            boolean caseInsensitiveIdentifiers = false;
            try (PreparedStatement prep = this.prepareStatement("SELECT NAME, VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME IN (?, ?, ?, ?)");){
                prep.setString(1, "MODE");
                prep.setString(2, "DATABASE_TO_UPPER");
                prep.setString(3, "DATABASE_TO_LOWER");
                prep.setString(4, "CASE_INSENSITIVE_IDENTIFIERS");
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    String value = rs.getString(2);
                    switch (rs.getString(1)) {
                        case "MODE": {
                            modeName = value;
                            break;
                        }
                        case "DATABASE_TO_UPPER": {
                            databaseToUpper = Boolean.valueOf(value);
                            break;
                        }
                        case "DATABASE_TO_LOWER": {
                            databaseToLower = Boolean.valueOf(value);
                            break;
                        }
                        case "CASE_INSENSITIVE_IDENTIFIERS": {
                            caseInsensitiveIdentifiers = Boolean.valueOf(value);
                        }
                    }
                }
            }
            Mode mode = Mode.getInstance(modeName);
            if (mode == null) {
                mode = Mode.getRegular();
            }
            if (this.session instanceof SessionRemote && ((SessionRemote)this.session).getClientVersion() < 18) {
                caseInsensitiveIdentifiers = !databaseToUpper;
            }
            this.settings = settings = new Settings(mode, databaseToUpper, databaseToLower, caseInsensitiveIdentifiers);
        }
        return settings;
    }

    public boolean isRegularMode() throws SQLException {
        this.settings = null;
        return this.getMode().getEnum() == Mode.ModeEnum.REGULAR;
    }

    public static final class Settings {
        public final Mode mode;
        public final boolean databaseToUpper;
        public final boolean databaseToLower;
        public final boolean caseInsensitiveIdentifiers;

        Settings(Mode mode, boolean databaseToUpper, boolean databaseToLower, boolean caseInsensitiveIdentifiers) {
            this.mode = mode;
            this.databaseToUpper = databaseToUpper;
            this.databaseToLower = databaseToLower;
            this.caseInsensitiveIdentifiers = caseInsensitiveIdentifiers;
        }
    }
}

