/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.SelectUnion;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexLookupBatch;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.SpatialIndex;
import org.gridgain.internal.h2.index.ViewCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.JoinBatch;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.IntArray;
import org.gridgain.internal.h2.value.Value;

public class ViewIndex
extends BaseIndex
implements SpatialIndex {
    private static final long MAX_AGE_NANOS = TimeUnit.MILLISECONDS.toNanos(10000L);
    private final TableView view;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private boolean recursive;
    private final int[] indexMasks;
    private Query query;
    private final Session createSession;
    private final long evaluatedAt;

    public ViewIndex(TableView view, String querySQL, ArrayList<Parameter> originalParameters, boolean recursive) {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.view = view;
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
        this.recursive = recursive;
        this.columns = new Column[0];
        this.createSession = null;
        this.indexMasks = null;
        this.evaluatedAt = Long.MIN_VALUE;
    }

    public ViewIndex(TableView view, ViewIndex index, Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        super(view, 0, null, null, IndexType.createNonUnique(false));
        this.view = view;
        this.querySQL = index.querySQL;
        this.originalParameters = index.originalParameters;
        this.recursive = index.recursive;
        this.indexMasks = masks;
        this.createSession = session;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session, masks, filters, filter, sortOrder);
        }
        this.evaluatedAt = this.recursive || view.getTopQuery() != null ? Long.MAX_VALUE : System.nanoTime();
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        if (this.recursive) {
            return null;
        }
        return JoinBatch.createViewIndexLookupBatch(this);
    }

    public Session getSession() {
        return this.createSession;
    }

    public boolean isExpired() {
        assert (this.evaluatedAt != Long.MIN_VALUE) : "must not be called for main index of TableView";
        return !this.recursive && this.view.getTopQuery() == null && System.nanoTime() - this.evaluatedAt > MAX_AGE_NANOS;
    }

    @Override
    public String getPlanSQL() {
        return this.query == null ? null : this.query.getPlanSQL(false);
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.recursive ? 1000.0 : this.query.getCost();
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session, first, last, null);
    }

    @Override
    public Cursor findByGeometry(TableFilter filter, SearchRow first, SearchRow last, SearchRow intersection) {
        return this.find(filter.getSession(), first, last, intersection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query prepareSubQuery(String sql, Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        Prepared p;
        session.pushSubQueryInfo(masks, filters, filter, sortOrder);
        try {
            p = session.prepare(sql, true, true);
        }
        finally {
            session.popSubQueryInfo();
        }
        return (Query)p;
    }

    private Cursor findRecursive(SearchRow first, SearchRow last) {
        assert (this.recursive);
        ResultInterface recursiveResult = this.view.getRecursiveResult();
        if (recursiveResult != null) {
            recursiveResult.reset();
            return new ViewCursor(this, recursiveResult, first, last);
        }
        if (this.query == null) {
            Parser parser = new Parser(this.createSession);
            parser.setRightsChecked(true);
            parser.setSuppliedParameterList(this.originalParameters);
            this.query = (Query)parser.prepare(this.querySQL);
            this.query.setNeverLazy(true);
        }
        if (!this.query.isUnion()) {
            throw DbException.get(42001, "recursive queries without UNION");
        }
        SelectUnion union = (SelectUnion)this.query;
        Query left = union.getLeft();
        left.setNeverLazy(true);
        left.disableCache();
        ResultInterface resultInterface = left.query(0);
        LocalResult localResult = union.getEmptyResult();
        localResult.setMaxMemoryRows(Integer.MAX_VALUE);
        while (resultInterface.next()) {
            Value[] cr = resultInterface.currentRow();
            localResult.addRow(cr);
        }
        Query right = union.getRight();
        right.setNeverLazy(true);
        resultInterface.reset();
        this.view.setRecursiveResult(resultInterface);
        right.disableCache();
        while ((resultInterface = right.query(0)).hasNext()) {
            while (resultInterface.next()) {
                Value[] cr = resultInterface.currentRow();
                localResult.addRow(cr);
            }
            resultInterface.reset();
            this.view.setRecursiveResult(resultInterface);
        }
        this.view.setRecursiveResult(null);
        localResult.done();
        return new ViewCursor(this, localResult, first, last);
    }

    public void setupQueryParameters(Session session, SearchRow first, SearchRow last, SearchRow intersection) {
        ArrayList<Parameter> paramList = this.query.getParameters();
        if (this.originalParameters != null) {
            for (Parameter orig : this.originalParameters) {
                int idx = orig.getIndex();
                Value value = orig.getValue(session);
                ViewIndex.setParameter(paramList, idx, value);
            }
        }
        int len = first != null ? first.getColumnCount() : (last != null ? last.getColumnCount() : (intersection != null ? intersection.getColumnCount() : 0));
        int idx = this.view.getParameterOffset(this.originalParameters);
        for (int i = 0; i < len; ++i) {
            int mask = this.indexMasks[i];
            if ((mask & 1) != 0) {
                ViewIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 2) != 0) {
                ViewIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 4) != 0) {
                ViewIndex.setParameter(paramList, idx++, last.getValue(i));
            }
            if ((mask & 0x10) == 0) continue;
            ViewIndex.setParameter(paramList, idx++, intersection.getValue(i));
        }
    }

    private Cursor find(Session session, SearchRow first, SearchRow last, SearchRow intersection) {
        if (this.recursive) {
            return this.findRecursive(first, last);
        }
        this.setupQueryParameters(session, first, last, intersection);
        ResultInterface result = this.query.query(0);
        return new ViewCursor(this, result, first, last);
    }

    private static void setParameter(ArrayList<Parameter> paramList, int x, Value v) {
        if (x >= paramList.size()) {
            return;
        }
        Parameter param = paramList.get(x);
        param.setValue(v);
    }

    public Query getQuery() {
        return this.query;
    }

    private Query getQuery(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        Query q = ViewIndex.prepareSubQuery(this.querySQL, session, masks, filters, filter, sortOrder);
        if (masks == null) {
            return q;
        }
        if (!q.allowGlobalConditions()) {
            return q;
        }
        int firstIndexParam = this.view.getParameterOffset(this.originalParameters);
        IntArray paramColumnIndex = new IntArray();
        int indexColumnCount = 0;
        for (int i = 0; i < masks.length; ++i) {
            int mask = masks[i];
            if (mask == 0) continue;
            ++indexColumnCount;
            int bitCount = Integer.bitCount(mask);
            for (int j = 0; j < bitCount; ++j) {
                paramColumnIndex.add(i);
            }
        }
        int len = paramColumnIndex.size();
        ArrayList<Column> columnList = new ArrayList<Column>(len);
        int i = 0;
        while (i < len) {
            Parameter param;
            int idx = paramColumnIndex.get(i);
            columnList.add(this.table.getColumn(idx));
            int mask = masks[idx];
            if ((mask & 1) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 16);
                ++i;
            }
            if ((mask & 2) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 1);
                ++i;
            }
            if ((mask & 4) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 3);
                ++i;
            }
            if ((mask & 0x10) == 0) continue;
            param = new Parameter(firstIndexParam + i);
            q.addGlobalCondition(param, idx, 11);
            ++i;
        }
        this.columns = columnList.toArray(new Column[0]);
        this.indexColumns = new IndexColumn[indexColumnCount];
        this.columnIds = new int[indexColumnCount];
        int indexColumnId = 0;
        for (int type = 0; type < 2; ++type) {
            for (int i2 = 0; i2 < masks.length; ++i2) {
                int mask = masks[i2];
                if (mask == 0 || (type == 0 ? (mask & 1) == 0 : (mask & 1) != 0)) continue;
                IndexColumn c = new IndexColumn();
                c.column = this.table.getColumn(i2);
                this.indexColumns[indexColumnId] = c;
                this.columnIds[indexColumnId] = c.column.getColumnId();
                ++indexColumnId;
            }
        }
        String sql = q.getPlanSQL(true);
        q = ViewIndex.prepareSubQuery(sql, session, masks, filters, filter, sortOrder);
        return q;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean value) {
        this.recursive = value;
    }

    @Override
    public long getRowCount(Session session) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return 0L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

