/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.NonUniqueHashCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;

public class NonUniqueHashIndex
extends BaseIndex {
    private final int indexColumn;
    private final boolean totalOrdering;
    private Map<Value, ArrayList<Long>> rows;
    private final PageStoreTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(PageStoreTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        Column column = columns[0].column;
        this.indexColumn = column.getColumnId();
        this.totalOrdering = DataType.hasTotalOrdering(column.getType().getValueType());
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        this.rows = this.totalOrdering ? new HashMap() : new TreeMap(this.database.getCompareMode());
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        ArrayList<Long> positions = this.rows.get(key);
        if (positions == null) {
            positions = Utils.newSmallArrayList();
            this.rows.put(key, positions);
        }
        positions.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value key = row.getValue(this.indexColumn);
            ArrayList<Long> positions = this.rows.get(key);
            if (positions.size() == 1) {
                this.rows.remove(key);
            } else {
                positions.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (first == null || last == null) {
            throw DbException.throwInternalError(first + " " + last);
        }
        if (first != last && this.compareKeys(first, last) != 0) {
            throw DbException.throwInternalError();
        }
        Value v = first.getValue(this.indexColumn);
        v = v.convertTo(this.tableData.getColumn(this.indexColumn).getType(), this.database.getMode(), null);
        ArrayList<Long> positions = this.rows.get(v);
        return new NonUniqueHashCursor(session, this.tableData, positions);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

