/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.aggregate;

import java.util.TreeMap;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.expression.aggregate.LongDataCounter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

class AggregateDataDistinctWithCounts
extends AggregateData {
    private final boolean ignoreNulls;
    private final int maxDistinctCount;
    private TreeMap<Value, LongDataCounter> values;
    private H2MemoryTracker tracker;

    AggregateDataDistinctWithCounts(boolean ignoreNulls, int maxDistinctCount) {
        this.ignoreNulls = ignoreNulls;
        this.maxDistinctCount = maxDistinctCount;
    }

    @Override
    void add(Session ses, Value v) {
        LongDataCounter a;
        if (this.ignoreNulls && v == ValueNull.INSTANCE) {
            return;
        }
        if (this.values == null) {
            this.values = new TreeMap(ses.getDatabase().getCompareMode());
        }
        if ((a = this.values.get(v)) == null) {
            if (this.values.size() >= this.maxDistinctCount) {
                return;
            }
            a = new LongDataCounter();
            this.values.put(v, a);
            if (this.tracker == null && ses.memoryTracker() != null) {
                this.tracker = ses.memoryTracker().createChildTracker();
            }
            if (this.tracker != null) {
                long size = 24L;
                this.tracker.reserve(size += (long)v.getMemory());
            }
        }
        ++a.count;
    }

    @Override
    public void mergeAggregate(Session ses, AggregateData agg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMemory() {
        return this.tracker.reserved();
    }

    @Override
    Value getValue(Database database, int dataType) {
        return null;
    }

    TreeMap<Value, LongDataCounter> getValues() {
        return this.values;
    }

    @Override
    public void cleanup(Session ses) {
        if (this.values != null && this.tracker != null) {
            this.values = null;
            this.tracker.release(this.tracker.reserved());
        }
    }
}

