/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueRow;

public class ExpressionList
extends Expression {
    private final Expression[] list;
    private final boolean isArray;

    public ExpressionList(Expression[] list, boolean isArray) {
        this.list = list;
        this.isArray = isArray;
    }

    @Override
    public Value getValue(Session session) {
        Value[] v = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            v[i] = this.list[i].getValue(session);
        }
        return this.isArray ? ValueArray.get(v) : ValueRow.get(v);
    }

    @Override
    public TypeInfo getType() {
        return this.isArray ? TypeInfo.TYPE_ARRAY : TypeInfo.TYPE_ROW;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        for (Expression e : this.list) {
            e.mapColumns(resolver, level, state);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean allConst = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression e = this.list[i].optimize(session);
            if (!e.isConstant()) {
                allConst = false;
            }
            this.list[i] = e;
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.list) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append(this.isArray ? "ARRAY [" : "ROW (");
        ExpressionList.writeExpressions(builder, this.list, alwaysQuote);
        return builder.append(this.isArray ? (char)']' : ')');
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        for (Expression e : this.list) {
            e.updateAggregate(session, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.list) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        for (Expression e : this.list) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        Expression[] expr = new ExpressionColumn[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Expression e = this.list[i];
            Column col = new Column("C" + (i + 1), e.getType());
            expr[i] = new ExpressionColumn(session.getDatabase(), col);
        }
        return expr;
    }

    @Override
    public boolean isConstant() {
        for (Expression e : this.list) {
            if (e.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSubexpressionCount() {
        return this.list.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.list[index];
    }
}

