/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import java.util.List;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueCollectionBase;

public abstract class Expression {
    public static final int MAP_INITIAL = 0;
    public static final int MAP_IN_WINDOW = 1;
    public static final int MAP_IN_AGGREGATE = 2;
    private boolean addedToFilter;

    public static void writeExpressions(StringBuilder builder, List<? extends Expression> expressions, boolean alwaysQuote) {
        int length = expressions.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            expressions.get(i).getSQL(builder, alwaysQuote);
        }
    }

    public static void writeExpressions(StringBuilder builder, Expression[] expressions, boolean alwaysQuote) {
        int length = expressions.length;
        for (int i = 0; i < length; ++i) {
            Expression e;
            if (i > 0) {
                builder.append(", ");
            }
            if ((e = expressions[i]) == null) {
                builder.append("DEFAULT");
                continue;
            }
            e.getSQL(builder, alwaysQuote);
        }
    }

    public abstract Value getValue(Session var1);

    public abstract TypeInfo getType();

    public abstract void mapColumns(ColumnResolver var1, int var2, int var3);

    public abstract Expression optimize(Session var1);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public String getSQL(boolean alwaysQuote) {
        return this.getSQL(new StringBuilder(), alwaysQuote).toString();
    }

    public abstract StringBuilder getSQL(StringBuilder var1, boolean var2);

    public StringBuilder getUnenclosedSQL(StringBuilder builder, boolean alwaysQuote) {
        int first = builder.length();
        int last = this.getSQL(builder, alwaysQuote).length() - 1;
        if (last > first && builder.charAt(first) == '(' && builder.charAt(last) == ')') {
            builder.setLength(last);
            builder.deleteCharAt(first);
        }
        return builder;
    }

    public abstract void updateAggregate(Session var1, int var2);

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract int getCost();

    public Expression getNotIfPossible(Session session) {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return false;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isGeneratedKey() {
        return false;
    }

    public boolean getBooleanValue(Session session) {
        return this.getValue(session).getBoolean();
    }

    public void createIndexConditions(Session session, TableFilter filter) {
    }

    public String getColumnName() {
        return this.getAlias();
    }

    public String getSchemaName() {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public int getNullable() {
        return 2;
    }

    public String getTableAlias() {
        return null;
    }

    public String getAlias() {
        return this.getUnenclosedSQL(new StringBuilder(), false).toString();
    }

    public Expression getNonAliasExpression() {
        return this;
    }

    public void addFilterConditions(TableFilter filter, boolean outerJoin) {
        if (!this.addedToFilter && !outerJoin && this.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
            filter.addFilterCondition(this, false);
            this.addedToFilter = true;
        }
    }

    public String toString() {
        return this.getSQL(false);
    }

    public Expression[] getExpressionColumns(Session session) {
        return null;
    }

    protected static Expression[] getExpressionColumns(Session session, ValueCollectionBase value) {
        Value[] list = value.getList();
        Expression[] expr = new ExpressionColumn[list.length];
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            Value v = list[i];
            Column col = new Column("C" + (i + 1), v.getType());
            expr[i] = new ExpressionColumn(session.getDatabase(), col);
        }
        return expr;
    }

    public static Expression[] getExpressionColumns(Session session, ResultInterface result) {
        int columnCount = result.getVisibleColumnCount();
        Expression[] expressions = new Expression[columnCount];
        Database db = session == null ? null : session.getDatabase();
        for (int i = 0; i < columnCount; ++i) {
            String name = result.getColumnName(i);
            TypeInfo type = result.getColumnType(i);
            Column col = new Column(name, type);
            ExpressionColumn expr = new ExpressionColumn(db, col);
            expressions[i] = expr;
        }
        return expressions;
    }

    public int getSubexpressionCount() {
        return 0;
    }

    public Expression getSubexpression(int index) {
        throw new IndexOutOfBoundsException();
    }
}

