/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import org.gridgain.internal.h2.command.ddl.SchemaCommand;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Table;

public class AlterTableSet
extends SchemaCommand {
    private boolean ifTableExists;
    private String tableName;
    private final int type;
    private final boolean value;
    private boolean checkExisting;

    public AlterTableSet(Session session, Schema schema, int type, boolean value) {
        super(session, schema);
        this.type = type;
        this.value = value;
    }

    public void setCheckExisting(boolean b) {
        this.checkExisting = b;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void setIfTableExists(boolean b) {
        this.ifTableExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public int update() {
        Table table = this.getSchema().resolveTableOrView(this.session, this.tableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.tableName);
        }
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true, true);
        switch (this.type) {
            case 55: {
                table.setCheckForeignKeyConstraints(this.session, this.value, this.value ? this.checkExisting : false);
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return this.type;
    }
}

