/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2Row;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.util.GridCursorIteratorWrapper;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexLookupBatch;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.SingleRowCursor;
import org.gridgain.internal.h2.index.SpatialIndex;
import org.gridgain.internal.h2.index.SpatialTreeIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.rtree.MVRTreeMap;
import org.gridgain.internal.h2.mvstore.rtree.SpatialKey;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class GridH2SpatialIndex
extends GridH2IndexBase
implements SpatialIndex {
    private final GridCacheContext ctx;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile long rowCnt;
    private long rowIds;
    private boolean closed;
    private final MVRTreeMap<Long>[] segments;
    private final Map<Long, H2CacheRow> idToRow = new HashMap<Long, H2CacheRow>();
    private final Map<Value, Long> keyToId = new HashMap<Value, Long>();
    private final MVStore store = MVStore.open(null);

    public GridH2SpatialIndex(GridH2Table tbl, String idxName, IndexColumn ... cols) {
        this(tbl, idxName, 1, cols);
    }

    public GridH2SpatialIndex(GridH2Table tbl, String idxName, int segmentsCnt, IndexColumn ... cols) {
        super(tbl, idxName, GridH2SpatialIndex.validateColumns(cols), IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)true));
        this.segments = new MVRTreeMap[segmentsCnt];
        for (int i = 0; i < segmentsCnt; ++i) {
            this.segments[i] = (MVRTreeMap)this.store.openMap("spatialIndex-" + i, (MVMap.MapBuilder)new MVRTreeMap.Builder());
        }
        this.ctx = tbl.rowDescriptor().context();
    }

    private static IndexColumn[] validateColumns(IndexColumn[] cols) {
        if (cols.length > 1) {
            throw DbException.getUnsupportedException((String)"can only do one column");
        }
        if ((cols[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do descending");
        }
        if ((cols[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do nulls first");
        }
        if ((cols[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do nulls last");
        }
        if (cols[0].column.getType().getValueType() != 22) {
            throw DbException.getUnsupportedException((String)("spatial index on non-geometry column, " + cols[0].column.getCreateSQL()));
        }
        return cols;
    }

    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        if (this.getTable().isPartitioned()) {
            assert (filter > 0);
            throw DbException.throwInternalError((String)("Table with a spatial index must be the first in the query: " + this.getTable()));
        }
        return null;
    }

    private void checkClosed() {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
    }

    public int segmentsCount() {
        return this.segments.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H2CacheRow put(H2CacheRow row) {
        assert (row instanceof H2CacheRow) : "requires key to be at 0";
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.checkClosed();
            Value key = row.getValue(0);
            assert (key != null);
            int seg = this.segmentForRow(this.ctx, (SearchRow)row);
            Long rowId = this.keyToId.get(key);
            if (rowId != null) {
                Long oldRowId = (Long)this.segments[seg].remove((Object)this.getEnvelope((SearchRow)this.idToRow.get(rowId), rowId));
                assert (rowId.equals(oldRowId));
            } else {
                rowId = ++this.rowIds;
                this.keyToId.put(key, rowId);
            }
            H2CacheRow old = this.idToRow.put(rowId, row);
            this.segments[seg].put(this.getEnvelope((SearchRow)row, rowId), (Object)rowId);
            if (old == null) {
                ++this.rowCnt;
            }
            H2CacheRow h2CacheRow = old;
            return h2CacheRow;
        }
        finally {
            l.unlock();
        }
    }

    public boolean putx(H2CacheRow row) {
        H2CacheRow old = this.put(row);
        return old != null;
    }

    private SpatialKey getEnvelope(SearchRow row, long rowId) {
        Value v = row.getValue(this.columnIds[0]);
        Geometry g = ((ValueGeometry)v.convertTo(22)).getGeometry();
        Envelope env = g.getEnvelopeInternal();
        return new SpatialKey(rowId, new float[]{(float)env.getMinX(), (float)env.getMaxX(), (float)env.getMinY(), (float)env.getMaxY()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private H2CacheRow remove(SearchRow row) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.checkClosed();
            Value key = row.getValue(0);
            assert (key != null);
            Long rowId = this.keyToId.remove(key);
            assert (rowId != null);
            H2CacheRow oldRow = this.idToRow.remove(rowId);
            assert (oldRow != null);
            int seg = this.segmentForRow(this.ctx, row);
            if (!this.segments[seg].remove((Object)this.getEnvelope(row, rowId), (Object)rowId)) {
                throw DbException.throwInternalError((String)"row not found");
            }
            --this.rowCnt;
            H2CacheRow h2CacheRow = oldRow;
            return h2CacheRow;
        }
        finally {
            l.unlock();
        }
    }

    public boolean removex(SearchRow row) {
        H2CacheRow old = this.remove(row);
        return old != null;
    }

    public void destroy(boolean rmIndex) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.closed = true;
            this.store.close();
        }
        finally {
            l.unlock();
        }
        super.destroy(rmIndex);
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan cols) {
        return SpatialTreeIndex.getCostRangeIndex((int[])masks, (Column[])this.columns) / 10L;
    }

    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find0(filter);
    }

    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        return this.find0(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor find0(TableFilter filter) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            this.checkClosed();
            int seg = this.segment(H2Utils.context((Session)filter.getSession()));
            MVRTreeMap<Long> segment = this.segments[seg];
            H2Cursor h2Cursor = new H2Cursor(this.rowIterator(segment.keySet().iterator(), filter));
            return h2Cursor;
        }
        finally {
            l.unlock();
        }
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    private GridCursor<H2Row> rowIterator(Iterator<SpatialKey> i, TableFilter filter) {
        if (!i.hasNext()) {
            return GridCursor.EMPTY_CURSOR;
        }
        long time = System.currentTimeMillis();
        IndexingQueryFilter qryFilter = null;
        QueryContext qctx = H2Utils.context((Session)filter.getSession());
        if (qctx != null) {
            qryFilter = qctx.filter();
        }
        IndexingQueryCacheFilter qryCacheFilter = qryFilter != null ? qryFilter.forCache(this.getTable().cacheName()) : null;
        ArrayList<H2CacheRow> rows = new ArrayList<H2CacheRow>();
        do {
            H2CacheRow row = this.idToRow.get(i.next().getId());
            assert (row != null);
            if (row.expireTime() != 0L && row.expireTime() <= time || qryCacheFilter != null && !qryCacheFilter.applyPartition(row.partition())) continue;
            rows.add(row);
        } while (i.hasNext());
        return new GridCursorIteratorWrapper(rows.iterator());
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            this.checkClosed();
            if (!first) {
                throw DbException.throwInternalError((String)"Spatial Index can only be fetch by ascending order");
            }
            int seg = this.segment(H2Utils.context((Session)ses));
            MVRTreeMap<Long> segment = this.segments[seg];
            GridCursor<H2Row> iter = this.rowIterator(segment.keySet().iterator(), null);
            SingleRowCursor singleRowCursor = new SingleRowCursor(iter.next() ? (Row)iter.get() : null);
            return singleRowCursor;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            l.unlock();
        }
    }

    public long getRowCount(Session ses) {
        return this.rowCnt;
    }

    public long getRowCountApproximation(Session ses) {
        return this.rowCnt;
    }

    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        return this.rowCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor findByGeometry(TableFilter filter, SearchRow first, SearchRow last, SearchRow intersection) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            if (intersection == null) {
                Cursor cursor = this.find(filter.getSession(), null, null);
                return cursor;
            }
            int seg = this.segment(H2Utils.context((Session)filter.getSession()));
            MVRTreeMap<Long> segment = this.segments[seg];
            H2Cursor h2Cursor = new H2Cursor(this.rowIterator((Iterator<SpatialKey>)segment.findIntersectingKeys(this.getEnvelope(intersection, 0L)), filter));
            return h2Cursor;
        }
        finally {
            l.unlock();
        }
    }
}

