/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.network.file.messages.FileHeaderBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileHeaderDeserializer
implements MessageDeserializer<FileHeader> {
    private final FileHeaderBuilder msg;

    FileHeaderDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileHeader();
    }

    public Class<FileHeader> klass() {
        return FileHeader.class;
    }

    public FileHeader getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileHeader());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("length");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.length(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("name");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.name(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileHeader.class);
    }
}

