/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.file.messages.FileChunkResponse;
import org.apache.ignite.internal.network.file.messages.FileChunkResponseBuilder;
import org.apache.ignite.internal.network.file.messages.FileChunkResponseSerializer;
import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileChunkResponseImpl
implements FileChunkResponse,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final FileTransferError error;

    private FileChunkResponseImpl(FileTransferError error) {
        this.error = error;
    }

    @Override
    public FileTransferError error() {
        return this.error;
    }

    public MessageSerializer serializer() {
        return FileChunkResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileChunkResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileChunkResponseImpl otherMessage = (FileChunkResponseImpl)other;
        return Objects.equals(this.error, otherMessage.error);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.error);
        return result;
    }

    public FileChunkResponseImpl clone() {
        try {
            return (FileChunkResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileChunkResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.error != null) {
            this.error.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.error != null) {
            this.error.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements FileChunkResponseBuilder {
        private FileTransferError error;

        private Builder() {
        }

        @Override
        public FileChunkResponseBuilder error(FileTransferError error) {
            this.error = error;
            return this;
        }

        @Override
        public FileTransferError error() {
            return this.error;
        }

        @Override
        public FileChunkResponse build() {
            return new FileChunkResponseImpl(this.error);
        }

        @Override
        public FileChunkResponse buildDeserialized() {
            return new FileChunkResponseImpl(this.error);
        }
    }
}

