/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileChunkMessageImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileChunkMessageSerializer
implements MessageSerializer<FileChunkMessage> {
    public static final FileChunkMessageSerializer INSTANCE = new FileChunkMessageSerializer();

    private FileChunkMessageSerializer() {
    }

    public boolean writeMessage(FileChunkMessage msg, MessageWriter writer) throws MessageMappingException {
        FileChunkMessageImpl message = (FileChunkMessageImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileChunkMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("data", message.data());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("fileName", message.fileName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeInt("number", message.number());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeUuid("transferId", message.transferId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

