/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileChunkMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileChunkMessageDeserializer
implements MessageDeserializer<FileChunkMessage> {
    private final FileChunkMessageBuilder msg;

    FileChunkMessageDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileChunkMessage();
    }

    public Class<FileChunkMessage> klass() {
        return FileChunkMessage.class;
    }

    public FileChunkMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileChunkMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readByteArray("data");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.data((byte[])tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("fileName");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.fileName((String)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("number");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.number(tmp);
                reader.incrementState();
            }
            case 3: {
                UUID tmp = reader.readUuid("transferId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transferId(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileChunkMessage.class);
    }
}

