/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.ignite.internal.network.file.ChunkedFileReader;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;

public class FileChunkMessagesStream
implements Iterable<FileChunkMessage>,
AutoCloseable {
    private final UUID transferId;
    private final Path path;
    private final ChunkedFileReader reader;
    private boolean closed = false;
    private final FileTransferFactory messageFactory = new FileTransferFactory();

    private FileChunkMessagesStream(UUID transferId, Path path, ChunkedFileReader reader) {
        this.transferId = transferId;
        this.path = path;
        this.reader = reader;
    }

    public static FileChunkMessagesStream fromPath(int chunkSize, UUID transferId, Path path) throws IOException {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("Chunk size must be positive");
        }
        return new FileChunkMessagesStream(transferId, path, ChunkedFileReader.open(path.toFile(), chunkSize));
    }

    boolean hasNextMessage() throws IOException {
        return !this.closed && this.reader.hasNextChunk();
    }

    FileChunkMessage nextMessage() throws IOException {
        if (this.hasNextMessage()) {
            return this.nextChunk();
        }
        throw new IllegalStateException("There are no more messages to send");
    }

    private FileChunkMessage nextChunk() throws IOException {
        return this.messageFactory.fileChunkMessage().transferId(this.transferId).fileName(this.path.getFileName().toString()).number(this.reader.nextChunkNumber()).data(this.reader.readNextChunk()).build();
    }

    public Path path() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.reader.close();
        }
    }

    @Override
    public Iterator<FileChunkMessage> iterator() {
        return new Iterator<FileChunkMessage>(){

            @Override
            public boolean hasNext() {
                try {
                    return FileChunkMessagesStream.this.hasNextMessage();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public FileChunkMessage next() {
                try {
                    return FileChunkMessagesStream.this.nextMessage();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    @Override
    public void forEach(Consumer<? super FileChunkMessage> action) {
        for (FileChunkMessage message : this) {
            action.accept(message);
        }
    }
}

