/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.file.messages.Identifier;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileTransferInitMessageDeserializer
implements MessageDeserializer<FileTransferInitMessage> {
    private final FileTransferInitMessageBuilder msg;

    FileTransferInitMessageDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileTransferInitMessage();
    }

    public Class<FileTransferInitMessage> klass() {
        return FileTransferInitMessage.class;
    }

    public FileTransferInitMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileTransferInitMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readList("headers", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.headers((List<FileHeader>)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (Identifier)reader.readMessage("identifier");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.identifier((Identifier)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readUuid("transferId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transferId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileTransferInitMessage.class);
    }
}

