/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.file.messages.FileChunkResponse;
import org.apache.ignite.internal.network.file.messages.FileChunkResponseImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileChunkResponseSerializer
implements MessageSerializer<FileChunkResponse> {
    public static final FileChunkResponseSerializer INSTANCE = new FileChunkResponseSerializer();

    private FileChunkResponseSerializer() {
    }

    public boolean writeMessage(FileChunkResponse msg, MessageWriter writer) throws MessageMappingException {
        FileChunkResponseImpl message = (FileChunkResponseImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileChunkResponse());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("error", (NetworkMessage)message.error());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

