/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileTransferErrorMessageImpl
implements FileTransferErrorMessage,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final FileTransferError error;
    @IgniteToStringInclude
    private final UUID transferId;

    private FileTransferErrorMessageImpl(FileTransferError error, UUID transferId) {
        this.error = error;
        this.transferId = transferId;
    }

    @Override
    public FileTransferError error() {
        return this.error;
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    public MessageSerializer serializer() {
        return FileTransferErrorMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileTransferErrorMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileTransferErrorMessageImpl otherMessage = (FileTransferErrorMessageImpl)other;
        return Objects.equals(this.error, otherMessage.error) && Objects.equals(this.transferId, otherMessage.transferId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.error, this.transferId);
        return result;
    }

    public FileTransferErrorMessageImpl clone() {
        try {
            return (FileTransferErrorMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileTransferErrorMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.error != null) {
            this.error.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.error != null) {
            this.error.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements FileTransferErrorMessageBuilder {
        private FileTransferError error;
        private UUID transferId;

        private Builder() {
        }

        @Override
        public FileTransferErrorMessageBuilder error(FileTransferError error) {
            Objects.requireNonNull(error, "error is not marked @Nullable");
            this.error = error;
            return this;
        }

        @Override
        public FileTransferErrorMessageBuilder transferId(UUID transferId) {
            Objects.requireNonNull(transferId, "transferId is not marked @Nullable");
            this.transferId = transferId;
            return this;
        }

        @Override
        public FileTransferError error() {
            return this.error;
        }

        @Override
        public UUID transferId() {
            return this.transferId;
        }

        @Override
        public FileTransferErrorMessage build() {
            return new FileTransferErrorMessageImpl(Objects.requireNonNull(this.error, "error is not marked @Nullable"), Objects.requireNonNull(this.transferId, "transferId is not marked @Nullable"));
        }

        @Override
        public FileTransferErrorMessage buildDeserialized() {
            return new FileTransferErrorMessageImpl(this.error, this.transferId);
        }
    }
}

