/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileChunkResponse;
import org.apache.ignite.internal.network.file.messages.FileChunkResponseBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileChunkResponseDeserializer
implements MessageDeserializer<FileChunkResponse> {
    private final FileChunkResponseBuilder msg;

    FileChunkResponseDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileChunkResponse();
    }

    public Class<FileChunkResponse> klass() {
        return FileChunkResponse.class;
    }

    public FileChunkResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileChunkResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                FileTransferError tmp = (FileTransferError)reader.readMessage("error");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.error(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileChunkResponse.class);
    }
}

