/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileChunkMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileChunkMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileChunkMessageImpl
implements FileChunkMessage,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final byte[] data;
    @IgniteToStringInclude
    private final String fileName;
    @IgniteToStringInclude
    private final int number;
    @IgniteToStringInclude
    private final UUID transferId;

    private FileChunkMessageImpl(byte[] data, String fileName, int number, UUID transferId) {
        this.data = data;
        this.fileName = fileName;
        this.number = number;
        this.transferId = transferId;
    }

    @Override
    public byte[] data() {
        return this.data;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public int number() {
        return this.number;
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    public MessageSerializer serializer() {
        return FileChunkMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileChunkMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileChunkMessageImpl otherMessage = (FileChunkMessageImpl)other;
        return Objects.equals(this.fileName, otherMessage.fileName) && Objects.equals(this.transferId, otherMessage.transferId) && Arrays.equals(this.data, otherMessage.data) && this.number == otherMessage.number;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.number, this.fileName, this.transferId);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public FileChunkMessageImpl clone() {
        try {
            return (FileChunkMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileChunkMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements FileChunkMessageBuilder {
        private byte[] data;
        private String fileName;
        private int number;
        private UUID transferId;

        private Builder() {
        }

        @Override
        public FileChunkMessageBuilder data(byte[] data) {
            Objects.requireNonNull(data, "data is not marked @Nullable");
            this.data = data;
            return this;
        }

        @Override
        public FileChunkMessageBuilder fileName(String fileName) {
            Objects.requireNonNull(fileName, "fileName is not marked @Nullable");
            this.fileName = fileName;
            return this;
        }

        @Override
        public FileChunkMessageBuilder number(int number) {
            this.number = number;
            return this;
        }

        @Override
        public FileChunkMessageBuilder transferId(UUID transferId) {
            Objects.requireNonNull(transferId, "transferId is not marked @Nullable");
            this.transferId = transferId;
            return this;
        }

        @Override
        public byte[] data() {
            return this.data;
        }

        @Override
        public String fileName() {
            return this.fileName;
        }

        @Override
        public int number() {
            return this.number;
        }

        @Override
        public UUID transferId() {
            return this.transferId;
        }

        @Override
        public FileChunkMessage build() {
            return new FileChunkMessageImpl(Objects.requireNonNull(this.data, "data is not marked @Nullable"), Objects.requireNonNull(this.fileName, "fileName is not marked @Nullable"), this.number, Objects.requireNonNull(this.transferId, "transferId is not marked @Nullable"));
        }

        @Override
        public FileChunkMessage buildDeserialized() {
            return new FileChunkMessageImpl(this.data, this.fileName, this.number, this.transferId);
        }
    }
}

