/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileTransferErrorSerializer
implements MessageSerializer<FileTransferError> {
    public static final FileTransferErrorSerializer INSTANCE = new FileTransferErrorSerializer();

    private FileTransferErrorSerializer() {
    }

    public boolean writeMessage(FileTransferError msg, MessageWriter writer) throws MessageMappingException {
        FileTransferErrorImpl message = (FileTransferErrorImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileTransferError());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeInt("code", message.code());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("message", message.message());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

