/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.Objects;
import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.network.file.messages.FileHeaderBuilder;
import org.apache.ignite.internal.network.file.messages.FileHeaderSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileHeaderImpl
implements FileHeader,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final long length;
    @IgniteToStringInclude
    private final String name;

    private FileHeaderImpl(long length, String name) {
        this.length = length;
        this.name = name;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public String name() {
        return this.name;
    }

    public MessageSerializer serializer() {
        return FileHeaderSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileHeaderImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileHeaderImpl otherMessage = (FileHeaderImpl)other;
        return Objects.equals(this.name, otherMessage.name) && this.length == otherMessage.length;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.length, this.name);
        return result;
    }

    public FileHeaderImpl clone() {
        try {
            return (FileHeaderImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileHeaderBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements FileHeaderBuilder {
        private long length;
        private String name;

        private Builder() {
        }

        @Override
        public FileHeaderBuilder length(long length) {
            this.length = length;
            return this;
        }

        @Override
        public FileHeaderBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public FileHeader build() {
            return new FileHeaderImpl(this.length, Objects.requireNonNull(this.name, "name is not marked @Nullable"));
        }

        @Override
        public FileHeader buildDeserialized() {
            return new FileHeaderImpl(this.length, this.name);
        }
    }
}

