/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessageImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileTransferInitMessageSerializer
implements MessageSerializer<FileTransferInitMessage> {
    public static final FileTransferInitMessageSerializer INSTANCE = new FileTransferInitMessageSerializer();

    private FileTransferInitMessageSerializer() {
    }

    public boolean writeMessage(FileTransferInitMessage msg, MessageWriter writer) throws MessageMappingException {
        FileTransferInitMessageImpl message = (FileTransferInitMessageImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileTransferInitMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeList("headers", message.headers(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("identifier", (NetworkMessage)message.identifier());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("transferId", message.transferId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

