/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferInitMessageSerializer;
import org.apache.ignite.internal.network.file.messages.Identifier;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileTransferInitMessageImpl
implements FileTransferInitMessage,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final List<FileHeader> headers;
    @IgniteToStringInclude
    private final Identifier identifier;
    @IgniteToStringInclude
    private final UUID transferId;

    private FileTransferInitMessageImpl(List<FileHeader> headers, Identifier identifier, UUID transferId) {
        this.headers = headers;
        this.identifier = identifier;
        this.transferId = transferId;
    }

    @Override
    public List<FileHeader> headers() {
        return this.headers;
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public UUID transferId() {
        return this.transferId;
    }

    public MessageSerializer serializer() {
        return FileTransferInitMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileTransferInitMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileTransferInitMessageImpl otherMessage = (FileTransferInitMessageImpl)other;
        return Objects.equals(this.headers, otherMessage.headers) && Objects.equals(this.identifier, otherMessage.identifier) && Objects.equals(this.transferId, otherMessage.transferId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.headers, this.identifier, this.transferId);
        return result;
    }

    public FileTransferInitMessageImpl clone() {
        try {
            return (FileTransferInitMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileTransferInitMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.headers != null) {
            for (FileHeader obj : this.headers) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
        if (this.identifier != null) {
            this.identifier.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.headers != null) {
            for (FileHeader obj : this.headers) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
        if (this.identifier != null) {
            this.identifier.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements FileTransferInitMessageBuilder {
        private List<FileHeader> headers;
        private Identifier identifier;
        private UUID transferId;

        private Builder() {
        }

        @Override
        public FileTransferInitMessageBuilder headers(List<FileHeader> headers) {
            Objects.requireNonNull(headers, "headers is not marked @Nullable");
            this.headers = headers;
            return this;
        }

        @Override
        public FileTransferInitMessageBuilder identifier(Identifier identifier) {
            Objects.requireNonNull(identifier, "identifier is not marked @Nullable");
            this.identifier = identifier;
            return this;
        }

        @Override
        public FileTransferInitMessageBuilder transferId(UUID transferId) {
            Objects.requireNonNull(transferId, "transferId is not marked @Nullable");
            this.transferId = transferId;
            return this;
        }

        @Override
        public List<FileHeader> headers() {
            return this.headers;
        }

        @Override
        public Identifier identifier() {
            return this.identifier;
        }

        @Override
        public UUID transferId() {
            return this.transferId;
        }

        @Override
        public FileTransferInitMessage build() {
            return new FileTransferInitMessageImpl(Objects.requireNonNull(this.headers, "headers is not marked @Nullable"), Objects.requireNonNull(this.identifier, "identifier is not marked @Nullable"), Objects.requireNonNull(this.transferId, "transferId is not marked @Nullable"));
        }

        @Override
        public FileTransferInitMessage buildDeserialized() {
            return new FileTransferInitMessageImpl(this.headers, this.identifier, this.transferId);
        }
    }
}

