/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessageImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileTransferErrorMessageSerializer
implements MessageSerializer<FileTransferErrorMessage> {
    public static final FileTransferErrorMessageSerializer INSTANCE = new FileTransferErrorMessageSerializer();

    private FileTransferErrorMessageSerializer() {
    }

    public boolean writeMessage(FileTransferErrorMessage msg, MessageWriter writer) throws MessageMappingException {
        FileTransferErrorMessageImpl message = (FileTransferErrorMessageImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileTransferErrorMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("error", (NetworkMessage)message.error());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("transferId", message.transferId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

