/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.UUID;
import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessage;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorMessageBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileTransferErrorMessageDeserializer
implements MessageDeserializer<FileTransferErrorMessage> {
    private final FileTransferErrorMessageBuilder msg;

    FileTransferErrorMessageDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileTransferErrorMessage();
    }

    public Class<FileTransferErrorMessage> klass() {
        return FileTransferErrorMessage.class;
    }

    public FileTransferErrorMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileTransferErrorMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (FileTransferError)reader.readMessage("error");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.error((FileTransferError)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("transferId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transferId((UUID)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileTransferErrorMessage.class);
    }
}

