/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.util.Objects;
import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class FileTransferErrorImpl
implements FileTransferError,
Cloneable {
    public static final short GROUP_TYPE = 200;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final int code;
    @IgniteToStringInclude
    private final String message;

    private FileTransferErrorImpl(int code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public MessageSerializer serializer() {
        return FileTransferErrorSerializer.INSTANCE;
    }

    public short groupType() {
        return 200;
    }

    public String toString() {
        return S.toString(FileTransferErrorImpl.class, (Object)this);
    }

    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FileTransferErrorImpl otherMessage = (FileTransferErrorImpl)other;
        return Objects.equals(this.message, otherMessage.message) && this.code == otherMessage.code;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.code, this.message);
        return result;
    }

    public FileTransferErrorImpl clone() {
        try {
            return (FileTransferErrorImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FileTransferErrorBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements FileTransferErrorBuilder {
        private int code;
        private String message;

        private Builder() {
        }

        @Override
        public FileTransferErrorBuilder code(int code) {
            this.code = code;
            return this;
        }

        @Override
        public FileTransferErrorBuilder message(String message) {
            Objects.requireNonNull(message, "message is not marked @Nullable");
            this.message = message;
            return this;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public FileTransferError build() {
            return new FileTransferErrorImpl(this.code, Objects.requireNonNull(this.message, "message is not marked @Nullable"));
        }

        @Override
        public FileTransferError buildDeserialized() {
            return new FileTransferErrorImpl(this.code, this.message);
        }
    }
}

