/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.network.file.messages.FileHeaderImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileHeaderSerializer
implements MessageSerializer<FileHeader> {
    public static final FileHeaderSerializer INSTANCE = new FileHeaderSerializer();

    private FileHeaderSerializer() {
    }

    public boolean writeMessage(FileHeader msg, MessageWriter writer) throws MessageMappingException {
        FileHeaderImpl message = (FileHeaderImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileHeader());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("length", message.length());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("name", message.name());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

