/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.annotations.Transferable;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;

@Transferable(value=1)
public interface FileHeader
extends NetworkMessage {
    public String name();

    public long length();

    public static FileHeader fromPath(FileTransferFactory factory, Path path) {
        return factory.fileHeader().name(path.getFileName().toString()).length(path.toFile().length()).build();
    }

    public static List<FileHeader> fromPaths(FileTransferFactory factory, List<Path> paths) {
        return paths.stream().map(path -> FileHeader.fromPath(factory, path)).collect(Collectors.toList());
    }
}

