/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.ignite.internal.network.file.FileTransferMessagesHandler;
import org.apache.ignite.internal.network.file.TransferredFilesCollector;
import org.apache.ignite.internal.network.file.exception.FileTransferException;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;
import org.apache.ignite.internal.network.file.messages.FileHeader;
import org.apache.ignite.internal.util.RefCountedObjectPool;

class FileReceiver {
    private final Map<UUID, FileTransferMessagesHandler> transferIdToHandler = new ConcurrentHashMap<UUID, FileTransferMessagesHandler>();
    private final Map<String, Set<UUID>> senderConsistentIdToTransferIds = new ConcurrentHashMap<String, Set<UUID>>();
    private final RefCountedObjectPool<String, ReentrantLock> senderConsistentIdToLock = new RefCountedObjectPool();

    FileReceiver() {
    }

    TransferredFilesCollector registerTransfer(String senderConsistentId, UUID transferId, List<FileHeader> headers, Path handlerDir) {
        return this.doInLock(senderConsistentId, () -> this.registerTransfer0(senderConsistentId, transferId, headers, handlerDir));
    }

    private TransferredFilesCollector registerTransfer0(String senderConsistentId, UUID transferId, List<FileHeader> headers, Path handlerDir) {
        FileTransferMessagesHandler handler = new FileTransferMessagesHandler(headers, handlerDir);
        this.transferIdToHandler.put(transferId, handler);
        this.senderConsistentIdToTransferIds.compute(senderConsistentId, (k, v) -> {
            if (v == null) {
                v = new HashSet<UUID>();
            }
            v.add(transferId);
            return v;
        });
        handler.collectedFiles().whenComplete((files, throwable) -> this.deregisterTransfer(senderConsistentId, transferId));
        return handler;
    }

    private void deregisterTransfer(String senderConsistentId, UUID transferId) {
        this.doInLock(senderConsistentId, () -> this.deregisterTransfer0(senderConsistentId, transferId));
    }

    private void deregisterTransfer0(String senderConsistentId, UUID transferId) {
        this.transferIdToHandler.remove(transferId);
        this.senderConsistentIdToTransferIds.compute(senderConsistentId, (k, v) -> {
            if (v != null) {
                v.remove(transferId);
                if (v.isEmpty()) {
                    return null;
                }
            }
            return v;
        });
    }

    void cancelTransfersFromSender(String senderConsistentId) {
        this.doInLock(senderConsistentId, () -> this.cancelTransfersFromSender0(senderConsistentId));
    }

    private void cancelTransfersFromSender0(String senderConsistentId) {
        Set<UUID> uuids = this.senderConsistentIdToTransferIds.remove(senderConsistentId);
        if (uuids != null) {
            uuids.forEach(uuid -> this.transferIdToHandler.get(uuid).handleFileTransferError((Throwable)((Object)new FileTransferException("Transfer was cancelled"))));
        }
    }

    void cancelTransfer(UUID transferId, Throwable error) {
        FileTransferMessagesHandler handler = this.transferIdToHandler.get(transferId);
        if (handler == null) {
            throw new FileTransferException("Handler is not found for unknown transferId: " + transferId);
        }
        handler.handleFileTransferError(error);
    }

    void receiveFileChunk(FileChunkMessage chunk) {
        FileTransferMessagesHandler handler = this.transferIdToHandler.get(chunk.transferId());
        if (handler == null) {
            throw new FileTransferException("Handler is not found for unknown transferId: " + chunk.transferId());
        }
        handler.handleFileChunk(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V doInLock(String senderConsistentId, Supplier<V> supplier) {
        Lock lock = (Lock)this.senderConsistentIdToLock.acquire((Object)senderConsistentId, ignored -> new ReentrantLock());
        lock.lock();
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInLock(String senderConsistentId, Runnable runnable) {
        Lock lock = (Lock)this.senderConsistentIdToLock.acquire((Object)senderConsistentId, ignored -> new ReentrantLock());
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }
}

