/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.network.file.exception.FileValidationException;
import org.apache.ignite.internal.network.file.messages.FileChunkMessage;

class ChunkedFileWriter
implements AutoCloseable {
    private final BufferedOutputStream stream;
    private final long expectedFileLength;
    private long bytesWritten = 0L;
    private int expectedNextChunkNumber = 0;
    private final Lock lock = new ReentrantLock();

    private ChunkedFileWriter(BufferedOutputStream stream, long expectedFileLength) {
        this.stream = stream;
        this.expectedFileLength = expectedFileLength;
    }

    static ChunkedFileWriter open(File file, long expectedFileLength) throws IOException {
        return new ChunkedFileWriter(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])), expectedFileLength);
    }

    boolean write(FileChunkMessage chunk) throws IOException {
        this.lock.lock();
        try {
            if (chunk.number() != this.expectedNextChunkNumber) {
                throw new FileValidationException("Chunk number mismatch: expected " + this.expectedNextChunkNumber + ", actual " + chunk.number());
            }
            this.stream.write(chunk.data());
            ++this.expectedNextChunkNumber;
            this.bytesWritten += (long)chunk.data().length;
            if (this.bytesWritten > this.expectedFileLength) {
                throw new FileValidationException("File size mismatch: expected " + this.expectedFileLength + ", actual " + this.bytesWritten);
            }
            if (this.bytesWritten == this.expectedFileLength) {
                this.close();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

