/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

class ChunkedFileReader
implements AutoCloseable {
    private final int chunkSize;
    private final BufferedInputStream stream;
    private int nextChunkNumber = 0;
    private boolean hasNextChunk;

    private ChunkedFileReader(int chunkSize, BufferedInputStream stream) throws IOException {
        this.chunkSize = chunkSize;
        this.stream = stream;
        this.hasNextChunk = stream.available() > 0;
    }

    static ChunkedFileReader open(File file, int chunkSize) throws IOException {
        return new ChunkedFileReader(chunkSize, new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
    }

    boolean hasNextChunk() {
        return this.hasNextChunk;
    }

    byte[] readNextChunk() throws IOException {
        if (!this.hasNextChunk()) {
            throw new IOException("No more chunks to read");
        }
        byte[] data = this.stream.readNBytes(this.chunkSize);
        ++this.nextChunkNumber;
        boolean bl = this.hasNextChunk = this.stream.available() > 0;
        if (!this.hasNextChunk) {
            this.stream.close();
        }
        return data;
    }

    int nextChunkNumber() throws IOException {
        if (!this.hasNextChunk()) {
            throw new IOException("No more chunks to read");
        }
        return this.nextChunkNumber;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

