/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.file.messages.FileTransferError;
import org.apache.ignite.internal.network.file.messages.FileTransferErrorBuilder;
import org.apache.ignite.internal.network.file.messages.FileTransferFactory;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class FileTransferErrorDeserializer
implements MessageDeserializer<FileTransferError> {
    private final FileTransferErrorBuilder msg;

    FileTransferErrorDeserializer(FileTransferFactory messageFactory) {
        this.msg = messageFactory.fileTransferError();
    }

    public Class<FileTransferError> klass() {
        return FileTransferError.class;
    }

    public FileTransferError getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(FileTransferTypeInfos.fileTransferError());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("code");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.code(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("message");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.message(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FileTransferError.class);
    }
}

