/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.file.messages;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.file.messages.FileDownloadRequest;
import org.apache.ignite.internal.network.file.messages.FileDownloadRequestImpl;
import org.apache.ignite.internal.network.file.messages.FileTransferTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class FileDownloadRequestSerializer
implements MessageSerializer<FileDownloadRequest> {
    public static final FileDownloadRequestSerializer INSTANCE = new FileDownloadRequestSerializer();

    private FileDownloadRequestSerializer() {
    }

    public boolean writeMessage(FileDownloadRequest msg, MessageWriter writer) throws MessageMappingException {
        FileDownloadRequestImpl message = (FileDownloadRequestImpl)msg;
        writer.setMessageTypeInfo(FileTransferTypeInfos.fileDownloadRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("identifier", (NetworkMessage)message.identifier());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("transferId", message.transferId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

